/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.v3.core.util.ObjectMapperFactory;
import io.swagger.v3.core.util.PrettyPrintHelper;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json31 {
    private static final Logger LOGGER = LoggerFactory.getLogger(Json31.class);

    public static ObjectMapper mapper() {
        return ObjectMapperHolder.MAPPER;
    }

    public static ObjectMapper converterMapper() {
        return ConverterMapperHolder.MAPPER;
    }

    public static ObjectWriter pretty() {
        return Json31.mapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }

    public static String pretty(Object o) {
        try {
            return Json31.pretty().writeValueAsString(o);
        }
        catch (Exception e) {
            PrettyPrintHelper.emitError(LOGGER, "Error serializing object to JSON (3.1)", e);
            return null;
        }
    }

    public static void prettyPrint(Object o) {
        try {
            String prettyString = Json31.pretty().writeValueAsString(o).replace("\r", "");
            PrettyPrintHelper.emit(LOGGER, prettyString);
        }
        catch (Exception e) {
            PrettyPrintHelper.emitError(LOGGER, "Error pretty-printing JSON (3.1)", e);
        }
    }

    public static Map<String, Object> jsonSchemaAsMap(String jsonSchema) {
        try {
            return (Map)Json31.mapper().readValue(jsonSchema, Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Exception converting jsonSchema to Map", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> jsonSchemaAsMap(Schema schema) {
        try {
            return (Map)Json31.mapper().readValue(Json31.mapper().writeValueAsString((Object)schema), Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Exception converting jsonSchema to Map", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> jsonSchemaAsMap(JsonNode schema) {
        try {
            return (Map)Json31.mapper().readValue(Json31.mapper().writeValueAsString((Object)schema), Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Exception converting jsonSchema to Map", (Throwable)e);
            return null;
        }
    }

    private static final class ConverterMapperHolder {
        private static final ObjectMapper MAPPER = ObjectMapperFactory.createJsonConverter();

        private ConverterMapperHolder() {
        }
    }

    private static final class ObjectMapperHolder {
        private static final ObjectMapper MAPPER = ObjectMapperFactory.createJson31();

        private ObjectMapperHolder() {
        }
    }
}

