/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Semaphore;

public class KeyedRoundRobinQueue<V> {
    private final Object lock = new Object();
    private Semaphore size = new Semaphore(0);
    private Map<Object, Queue<V>> queues = new HashMap<Object, Queue<V>>();
    private List<Object> keyOrder = new ArrayList<Object>();
    private int currIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, V val) {
        Object object = this.lock;
        synchronized (object) {
            Queue<V> queue = this.queues.get(key);
            if (queue == null) {
                queue = new LinkedList<V>();
                this.queues.put(key, queue);
                this.keyOrder.add(key);
            }
            queue.add(val);
        }
        this.size.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V take() throws InterruptedException {
        this.size.acquire();
        Object object = this.lock;
        synchronized (object) {
            Object key = this.keyOrder.get(this.currIndex);
            Queue<V> queue = this.queues.get(key);
            V ret = queue.remove();
            if (queue.isEmpty()) {
                this.keyOrder.remove(this.currIndex);
                this.queues.remove(key);
                this.currIndex = this.keyOrder.size() == 0 ? 0 : (this.currIndex %= this.keyOrder.size());
            } else {
                this.currIndex = (this.currIndex + 1) % this.keyOrder.size();
            }
            return ret;
        }
    }
}

