/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.storm.StormTimer;
import org.apache.storm.metrics2.MetricRegistryProvider;
import org.apache.storm.metrics2.RateCounter;
import org.apache.storm.metrics2.SimpleGauge;
import org.apache.storm.metrics2.TaskMetricDimensions;
import org.apache.storm.metrics2.TaskMetricRepo;
import org.apache.storm.metrics2.reporters.StormReporter;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormMetricRegistry
implements MetricRegistryProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StormMetricRegistry.class);
    private static final String WORKER_METRIC_PREFIX = "storm.worker.";
    private static final String TOPOLOGY_METRIC_PREFIX = "storm.topology.";
    private static final int RATE_COUNTER_UPDATE_INTERVAL_SECONDS = 2;
    private final MetricRegistry registry = new MetricRegistry();
    private final List<StormReporter> reporters = new ArrayList<StormReporter>();
    private final ConcurrentMap<Integer, Map<String, Gauge>> taskIdGauges = new ConcurrentHashMap<Integer, Map<String, Gauge>>();
    private final ConcurrentMap<Integer, Map<String, Meter>> taskIdMeters = new ConcurrentHashMap<Integer, Map<String, Meter>>();
    private final ConcurrentMap<Integer, Map<String, Counter>> taskIdCounters = new ConcurrentHashMap<Integer, Map<String, Counter>>();
    private final ConcurrentMap<Integer, Map<String, Timer>> taskIdTimers = new ConcurrentHashMap<Integer, Map<String, Timer>>();
    private final ConcurrentMap<Integer, Map<String, Histogram>> taskIdHistograms = new ConcurrentHashMap<Integer, Map<String, Histogram>>();
    private final ConcurrentMap<TaskMetricDimensions, TaskMetricRepo> taskMetrics = new ConcurrentHashMap<TaskMetricDimensions, TaskMetricRepo>();
    private String hostName = null;
    private int port = -1;
    private String topologyId = null;
    private StormTimer metricTimer;
    private Set<RateCounter> rateCounters = ConcurrentHashMap.newKeySet();

    public RateCounter rateCounter(String metricName, String topologyId, String componentId, int taskId, int workerPort, String streamId) {
        RateCounter rateCounter = new RateCounter(this, metricName, topologyId, componentId, taskId, workerPort, streamId);
        this.rateCounters.add(rateCounter);
        return rateCounter;
    }

    public RateCounter rateCounter(String metricName, String componentId, int taskId) {
        RateCounter rateCounter = new RateCounter(this, metricName, this.topologyId, componentId, taskId, this.port);
        this.rateCounters.add(rateCounter);
        return rateCounter;
    }

    public <T> SimpleGauge<T> gauge(T initialValue, String name, String topologyId, String componentId, Integer taskId, Integer port) {
        SimpleGauge<T> gauge = new SimpleGauge<T>(initialValue);
        MetricNames metricNames = this.workerMetricName(name, topologyId, componentId, taskId, port);
        gauge = this.registerGauge(metricNames, gauge, taskId, componentId, null);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, gauge, this.taskIdGauges);
        return gauge;
    }

    public <T> Gauge<T> gauge(String name, Gauge<T> gauge, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        gauge = this.registerGauge(metricNames, gauge, context.getThisTaskId(), context.getThisComponentId(), null);
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, gauge, this.taskIdGauges);
        return gauge;
    }

    @Deprecated
    public <T> Gauge<T> gauge(String name, Gauge<T> gauge, String topologyId, String componentId, Integer taskId, Integer port) {
        MetricNames metricNames = this.workerMetricName(name, topologyId, componentId, taskId, port);
        gauge = this.registerGauge(metricNames, gauge, taskId, componentId, null);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, gauge, this.taskIdGauges);
        return gauge;
    }

    public <T> Gauge<T> gauge(String name, Gauge<T> gauge, String componentId, Integer taskId) {
        MetricNames metricNames = this.workerMetricName(name, this.topologyId, componentId, taskId, this.port);
        gauge = this.registerGauge(metricNames, gauge, taskId, componentId, null);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, gauge, this.taskIdGauges);
        return gauge;
    }

    public <T> Gauge<T> gauge(String name, Gauge<T> gauge, String topologyId, String componentId, String streamId, Integer taskId, Integer port) {
        MetricNames metricNames = this.workerMetricName(name, topologyId, componentId, streamId, taskId, port);
        gauge = this.registerGauge(metricNames, gauge, taskId, componentId, streamId);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, gauge, this.taskIdGauges);
        return gauge;
    }

    public Meter meter(String name, WorkerTopologyContext context, String componentId, Integer taskId, String streamId) {
        MetricNames metricNames = this.workerMetricName(name, context.getStormId(), componentId, streamId, taskId, context.getThisWorkerPort());
        Meter meter = this.registerMeter(metricNames, new Meter(), taskId, componentId, streamId);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, meter, this.taskIdMeters);
        return meter;
    }

    public Meter meter(String name, WorkerTopologyContext context, String componentId, Integer taskId) {
        MetricNames metricNames = this.workerMetricName(name, context.getStormId(), componentId, taskId, context.getThisWorkerPort());
        Meter meter = this.registerMeter(metricNames, new Meter(), taskId, componentId, null);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, meter, this.taskIdMeters);
        return meter;
    }

    public Meter meter(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Meter meter = this.registerMeter(metricNames, new Meter(), context.getThisTaskId(), context.getThisComponentId(), null);
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, meter, this.taskIdMeters);
        return meter;
    }

    public Counter counter(String name, WorkerTopologyContext context, String componentId, Integer taskId, String streamId) {
        MetricNames metricNames = this.workerMetricName(name, context.getStormId(), componentId, streamId, taskId, context.getThisWorkerPort());
        Counter counter = this.registerCounter(metricNames, new Counter(), taskId, componentId, streamId);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, counter, this.taskIdCounters);
        return counter;
    }

    public Counter counter(String name, String topologyId, String componentId, Integer taskId, Integer workerPort, String streamId) {
        MetricNames metricNames = this.workerMetricName(name, topologyId, componentId, streamId, taskId, workerPort);
        Counter counter = this.registerCounter(metricNames, new Counter(), taskId, componentId, streamId);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, counter, this.taskIdCounters);
        return counter;
    }

    public Counter counter(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Counter counter = this.registerCounter(metricNames, new Counter(), context.getThisTaskId(), context.getThisComponentId(), null);
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, counter, this.taskIdCounters);
        return counter;
    }

    public Counter counter(String name, String componentId, Integer taskId) {
        MetricNames metricNames = this.workerMetricName(name, this.topologyId, componentId, taskId, this.port);
        Counter counter = this.registerCounter(metricNames, new Counter(), taskId, componentId, null);
        StormMetricRegistry.saveMetricTaskIdMapping(taskId, metricNames, counter, this.taskIdCounters);
        return counter;
    }

    public Timer timer(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Timer timer = this.registerTimer(metricNames, new Timer(), context.getThisTaskId(), context.getThisComponentId(), null);
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, timer, this.taskIdTimers);
        return timer;
    }

    public Histogram histogram(String name, TopologyContext context) {
        MetricNames metricNames = this.topologyMetricName(name, context);
        Histogram histogram = this.registerHistogram(metricNames, new Histogram((Reservoir)new ExponentiallyDecayingReservoir()), context.getThisTaskId(), context.getThisComponentId(), null);
        StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, histogram, this.taskIdHistograms);
        return histogram;
    }

    public void metricSet(String prefix, MetricSet set, TopologyContext context) {
        for (Map.Entry entry : set.getMetrics().entrySet()) {
            MetricNames metricNames = this.topologyMetricName(prefix + "." + (String)entry.getKey(), context);
            Metric metric = (Metric)entry.getValue();
            if (metric instanceof Gauge) {
                this.registerGauge(metricNames, (Gauge)metric, context.getThisTaskId(), context.getThisComponentId(), null);
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Gauge)metric, this.taskIdGauges);
                continue;
            }
            if (metric instanceof Meter) {
                this.registerMeter(metricNames, (Meter)metric, context.getThisTaskId(), context.getThisComponentId(), null);
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Meter)metric, this.taskIdMeters);
                continue;
            }
            if (metric instanceof Counter) {
                this.registerCounter(metricNames, (Counter)metric, context.getThisTaskId(), context.getThisComponentId(), null);
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Counter)metric, this.taskIdCounters);
                continue;
            }
            if (metric instanceof Timer) {
                this.registerTimer(metricNames, (Timer)metric, context.getThisTaskId(), context.getThisComponentId(), null);
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Timer)metric, this.taskIdTimers);
                continue;
            }
            if (metric instanceof Histogram) {
                this.registerHistogram(metricNames, (Histogram)metric, context.getThisTaskId(), context.getThisComponentId(), null);
                StormMetricRegistry.saveMetricTaskIdMapping(context.getThisTaskId(), metricNames, (Histogram)metric, this.taskIdHistograms);
                continue;
            }
            LOG.error("Unable to save taskId mapping for metric {} named {}", (Object)metric, (Object)metricNames.getLongName());
        }
    }

    private static <T extends Metric> void saveMetricTaskIdMapping(Integer taskId, MetricNames names, T metric, Map<Integer, Map<String, T>> taskIdMetrics) {
        Map metrics = taskIdMetrics.computeIfAbsent(taskId, tid -> new ConcurrentHashMap());
        metrics.put(names.getShortName(), metric);
    }

    private <T> Gauge<T> registerGauge(MetricNames metricNames, Gauge<T> gauge, int taskId, String componentId, String streamId) {
        TaskMetricDimensions taskMetricDimensions = new TaskMetricDimensions(taskId, componentId, streamId, this);
        TaskMetricRepo repo = this.taskMetrics.computeIfAbsent(taskMetricDimensions, k -> new TaskMetricRepo());
        repo.addGauge(metricNames.getShortName(), gauge);
        gauge = (Gauge)this.registry.register(metricNames.getLongName(), gauge);
        return gauge;
    }

    private Meter registerMeter(MetricNames metricNames, Meter meter, int taskId, String componentId, String streamId) {
        TaskMetricDimensions taskMetricDimensions = new TaskMetricDimensions(taskId, componentId, streamId, this);
        TaskMetricRepo repo = this.taskMetrics.computeIfAbsent(taskMetricDimensions, k -> new TaskMetricRepo());
        repo.addMeter(metricNames.getShortName(), meter);
        meter = (Meter)this.registry.register(metricNames.getLongName(), (Metric)meter);
        return meter;
    }

    private Counter registerCounter(MetricNames metricNames, Counter counter, int taskId, String componentId, String streamId) {
        TaskMetricDimensions taskMetricDimensions = new TaskMetricDimensions(taskId, componentId, streamId, this);
        TaskMetricRepo repo = this.taskMetrics.computeIfAbsent(taskMetricDimensions, k -> new TaskMetricRepo());
        repo.addCounter(metricNames.getShortName(), counter);
        counter = (Counter)this.registry.register(metricNames.getLongName(), (Metric)counter);
        return counter;
    }

    private Timer registerTimer(MetricNames metricNames, Timer timer, int taskId, String componentId, String streamId) {
        TaskMetricDimensions taskMetricDimensions = new TaskMetricDimensions(taskId, componentId, streamId, this);
        TaskMetricRepo repo = this.taskMetrics.computeIfAbsent(taskMetricDimensions, k -> new TaskMetricRepo());
        repo.addTimer(metricNames.getShortName(), timer);
        timer = (Timer)this.registry.register(metricNames.getLongName(), (Metric)timer);
        return timer;
    }

    private Histogram registerHistogram(MetricNames metricNames, Histogram histogram, int taskId, String componentId, String streamId) {
        TaskMetricDimensions taskMetricDimensions = new TaskMetricDimensions(taskId, componentId, streamId, this);
        TaskMetricRepo repo = this.taskMetrics.computeIfAbsent(taskMetricDimensions, k -> new TaskMetricRepo());
        repo.addHistogram(metricNames.getShortName(), histogram);
        histogram = (Histogram)this.registry.register(metricNames.getLongName(), (Metric)histogram);
        return histogram;
    }

    public void deregister(Set<Metric> toRemove) {
        RemoveMetricFilter metricFilter = new RemoveMetricFilter(toRemove);
        for (TaskMetricRepo taskMetricRepo : this.taskMetrics.values()) {
            taskMetricRepo.degister(metricFilter);
        }
        this.registry.removeMatching((MetricFilter)metricFilter);
    }

    private <T extends Metric> Map<String, T> getMetricNameMap(int taskId, Map<Integer, Map<String, T>> taskIdMetrics) {
        HashMap ret = new HashMap();
        Map taskMetrics = taskIdMetrics.getOrDefault(taskId, Collections.emptyMap());
        ret.putAll(taskMetrics);
        return ret;
    }

    public Map<String, Gauge> getTaskGauges(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdGauges);
    }

    public Map<String, Counter> getTaskCounters(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdCounters);
    }

    public Map<String, Histogram> getTaskHistograms(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdHistograms);
    }

    public Map<String, Meter> getTaskMeters(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdMeters);
    }

    public Map<String, Timer> getTaskTimers(int taskId) {
        return this.getMetricNameMap(taskId, this.taskIdTimers);
    }

    public void start(Map<String, Object> topoConf, int port) {
        try {
            this.hostName = this.dotToUnderScore(Utils.localHostname());
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine hostname while starting the metrics system. Hostname will be reported as 'localhost'.");
        }
        this.topologyId = (String)topoConf.get("storm.id");
        this.port = port;
        this.metricTimer = new StormTimer("MetricRegistryTimer", (thread, exception) -> {
            LOG.error("Error when processing metric event", exception);
            Utils.exitProcess(20, "Error when processing metric event");
        });
        this.metricTimer.scheduleRecurring(2, 2, new RateCounterUpdater());
        LOG.info("Starting metrics reporters...");
        List reporterList = (List)topoConf.get("topology.metrics.reporters");
        if (reporterList != null && reporterList.size() > 0) {
            for (Map reporterConfig : reporterList) {
                this.startReporter(topoConf, reporterConfig);
            }
        }
    }

    private void startReporter(Map<String, Object> topoConf, Map<String, Object> reporterConfig) {
        String clazz = (String)reporterConfig.get("class");
        LOG.info("Attempting to instantiate reporter class: {}", (Object)clazz);
        StormReporter reporter = (StormReporter)ReflectionUtils.newInstance(clazz);
        if (reporter != null) {
            reporter.prepare(this, topoConf, reporterConfig);
            reporter.start();
            this.reporters.add(reporter);
        }
    }

    public void stop() {
        for (StormReporter sr : this.reporters) {
            sr.stop();
        }
        try {
            this.metricTimer.close();
        }
        catch (InterruptedException e) {
            LOG.warn("Exception while stopping", (Throwable)e);
        }
    }

    public int getRateCounterUpdateIntervalSeconds() {
        return 2;
    }

    @Override
    public MetricRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Map<TaskMetricDimensions, TaskMetricRepo> getTaskMetrics() {
        return this.taskMetrics;
    }

    String getHostName() {
        return this.hostName;
    }

    String getTopologyId() {
        return this.topologyId;
    }

    Integer getPort() {
        return this.port;
    }

    private MetricNames workerMetricName(String name, String stormId, String componentId, String streamId, Integer taskId, Integer workerPort) {
        StringBuilder sb = new StringBuilder(WORKER_METRIC_PREFIX);
        sb.append(stormId);
        sb.append(".");
        sb.append(this.hostName);
        sb.append(".");
        sb.append(this.dotToUnderScore(componentId));
        sb.append(".");
        sb.append(this.dotToUnderScore(streamId));
        sb.append(".");
        sb.append(taskId);
        sb.append(".");
        sb.append(workerPort);
        sb.append("-");
        sb.append(name);
        String longName = sb.toString();
        MetricNames names = new MetricNames(longName, name);
        return names;
    }

    private MetricNames workerMetricName(String name, String stormId, String componentId, Integer taskId, Integer workerPort) {
        StringBuilder sb = new StringBuilder(WORKER_METRIC_PREFIX);
        sb.append(stormId);
        sb.append(".");
        sb.append(this.hostName);
        sb.append(".");
        sb.append(this.dotToUnderScore(componentId));
        sb.append(".");
        sb.append(taskId);
        sb.append(".");
        sb.append(workerPort);
        sb.append("-");
        sb.append(name);
        String longName = sb.toString();
        MetricNames names = new MetricNames(longName, name);
        return names;
    }

    private MetricNames topologyMetricName(String name, TopologyContext context) {
        StringBuilder sb = new StringBuilder(TOPOLOGY_METRIC_PREFIX);
        sb.append(context.getStormId());
        sb.append(".");
        sb.append(this.hostName);
        sb.append(".");
        sb.append(this.dotToUnderScore(context.getThisComponentId()));
        sb.append(".");
        sb.append(context.getThisTaskId());
        sb.append(".");
        sb.append(context.getThisWorkerPort());
        sb.append("-");
        sb.append(name);
        String longName = sb.toString();
        MetricNames names = new MetricNames(longName, name);
        return names;
    }

    private String dotToUnderScore(String str) {
        return str.replace('.', '_');
    }

    private static class MetricNames {
        private String longName;
        private String shortName;

        MetricNames(String longName, String shortName) {
            this.longName = longName;
            this.shortName = shortName;
        }

        String getLongName() {
            return this.longName;
        }

        String getShortName() {
            return this.shortName;
        }
    }

    private static class RemoveMetricFilter
    implements MetricFilter {
        private Set<Metric> metrics = new HashSet<Metric>();

        RemoveMetricFilter(Set<Metric> toRemove) {
            this.metrics.addAll(toRemove);
            for (Metric metric : toRemove) {
                if (!(metric instanceof RateCounter)) continue;
                RateCounter rateCounter = (RateCounter)metric;
                this.metrics.add((Metric)rateCounter.getCounter());
            }
        }

        public boolean matches(String name, Metric metric) {
            return this.metrics.contains(metric);
        }
    }

    private class RateCounterUpdater
    implements Runnable {
        private RateCounterUpdater() {
        }

        @Override
        public void run() {
            for (RateCounter rateCounter : StormMetricRegistry.this.rateCounters) {
                rateCounter.update();
            }
        }
    }
}

