/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.utils.ObjectReader;

public class ClientMetricsUtils {
    private static final String RATE_UNIT = "rate.unit";
    private static final String DURATION_UNIT = "duration.unit";
    private static final String LOCALE = "locale";

    public static TimeUnit getMetricsRateUnit(Map<String, Object> reporterConf) {
        return ClientMetricsUtils.getTimeUnitForConfig(reporterConf, RATE_UNIT);
    }

    public static TimeUnit getMetricsDurationUnit(Map<String, Object> reporterConf) {
        return ClientMetricsUtils.getTimeUnitForConfig(reporterConf, DURATION_UNIT);
    }

    public static Locale getMetricsReporterLocale(Map<String, Object> reporterConf) {
        String languageTag = ObjectReader.getString(reporterConf.get(LOCALE), null);
        if (languageTag != null) {
            return Locale.forLanguageTag(languageTag);
        }
        return null;
    }

    public static TimeUnit getTimeUnitForConfig(Map<String, Object> reporterConf, String configName) {
        String timeUnitString = ObjectReader.getString(reporterConf.get(configName), null);
        if (timeUnitString != null) {
            return TimeUnit.valueOf(timeUnitString);
        }
        return null;
    }
}

