/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets;

import io.dropwizard.servlets.Servlets;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;

public class ThreadNameFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Thread current = Thread.currentThread();
        String oldName = current.getName();
        try {
            current.setName(ThreadNameFilter.formatName(req, oldName));
            chain.doFilter(request, response);
        }
        finally {
            current.setName(oldName);
        }
    }

    private static String formatName(HttpServletRequest req, String oldName) {
        return oldName + " - " + req.getMethod() + " " + Servlets.getFullUrl(req);
    }
}

