/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.recipes.nodes;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.storm.shade.org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.org.apache.curator.utils.CloseableScheduledExecutorService;
import org.apache.storm.shade.org.apache.curator.utils.ThreadUtils;
import org.apache.storm.shade.org.apache.curator.utils.ZKPaths;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTtlNode
implements Closeable {
    public static final String DEFAULT_CHILD_NODE_NAME = "touch";
    public static final int DEFAULT_TOUCH_SCHEDULE_FACTOR = 2;
    public static final boolean DEFAULT_USE_PARENT_CREATION = true;
    @VisibleForTesting
    static final String TOUCH_THREAD_NAME = "PersistentTtlNode";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PersistentNode node;
    private final CuratorFramework client;
    private final long ttlMs;
    private final int touchScheduleFactor;
    private final CloseableScheduledExecutorService closeableExecutorService;
    private final String childPath;

    public PersistentTtlNode(CuratorFramework client, String path, long ttlMs, byte[] initData) {
        this(client, new CloseableScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(ThreadUtils.newThreadFactory(TOUCH_THREAD_NAME)), true), path, ttlMs, initData, DEFAULT_CHILD_NODE_NAME, 2, true);
    }

    public PersistentTtlNode(CuratorFramework client, String path, long ttlMs, byte[] initData, boolean useParentCreation) {
        this(client, new CloseableScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(ThreadUtils.newThreadFactory(TOUCH_THREAD_NAME)), true), path, ttlMs, initData, DEFAULT_CHILD_NODE_NAME, 2, useParentCreation);
    }

    public PersistentTtlNode(CuratorFramework client, ScheduledExecutorService executorService, String path, long ttlMs, byte[] initData, String childNodeName, int touchScheduleFactor) {
        this(client, new CloseableScheduledExecutorService(executorService), path, ttlMs, initData, childNodeName, touchScheduleFactor, true);
    }

    public PersistentTtlNode(CuratorFramework client, ScheduledExecutorService executorService, String path, long ttlMs, byte[] initData, String childNodeName, int touchScheduleFactor, boolean useParentCreation) {
        this(client, new CloseableScheduledExecutorService(executorService, false), path, ttlMs, initData, childNodeName, touchScheduleFactor, useParentCreation);
    }

    private PersistentTtlNode(CuratorFramework client, CloseableScheduledExecutorService closeableExecutorService, String path, long ttlMs, byte[] initData, String childNodeName, int touchScheduleFactor, boolean useParentCreation) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.ttlMs = ttlMs;
        this.touchScheduleFactor = touchScheduleFactor;
        this.node = new PersistentNode(client, CreateMode.PERSISTENT_WITH_TTL, false, path, initData, ttlMs, useParentCreation){

            @Override
            protected void deleteNode() {
            }
        };
        this.closeableExecutorService = closeableExecutorService;
        this.childPath = ZKPaths.makePath(Objects.requireNonNull(path, "path cannot be null"), childNodeName);
    }

    @VisibleForTesting
    void touch() {
        block5: {
            try {
                try {
                    this.client.setData().forPath(this.childPath);
                }
                catch (KeeperException.NoNodeException e) {
                    ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().withTtl(this.ttlMs).withMode(CreateMode.PERSISTENT_WITH_TTL)).forPath(this.childPath);
                }
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (Exception e) {
                if (ThreadUtils.checkInterrupted(e)) break block5;
                this.log.debug("Could not touch child node", (Throwable)e);
            }
        }
    }

    public void start() {
        this.node.start();
        this.closeableExecutorService.scheduleAtFixedRate(this::touch, this.ttlMs / (long)this.touchScheduleFactor, this.ttlMs / (long)this.touchScheduleFactor, TimeUnit.MILLISECONDS);
    }

    public boolean waitForInitialCreate(long timeout, TimeUnit unit) throws InterruptedException {
        return this.node.waitForInitialCreate(timeout, unit);
    }

    public void setData(byte[] data) throws Exception {
        this.node.setData(data);
    }

    public byte[] getData() {
        return this.node.getData();
    }

    @VisibleForTesting
    CloseableScheduledExecutorService getCloseableScheduledExecutorService() {
        return this.closeableExecutorService;
    }

    @Override
    public void close() {
        this.closeableExecutorService.close();
        try {
            this.node.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

