/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.retry;

import org.apache.storm.shade.org.apache.curator.RetrySleeper;
import org.apache.storm.shade.org.apache.curator.retry.SleepingRetry;

public class RetryUntilElapsed
extends SleepingRetry {
    private final int maxElapsedTimeMs;
    private final int sleepMsBetweenRetries;

    public RetryUntilElapsed(int maxElapsedTimeMs, int sleepMsBetweenRetries) {
        super(Integer.MAX_VALUE);
        this.maxElapsedTimeMs = maxElapsedTimeMs;
        this.sleepMsBetweenRetries = sleepMsBetweenRetries;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        return super.allowRetry(retryCount, elapsedTimeMs, sleeper) && elapsedTimeMs < (long)this.maxElapsedTimeMs;
    }

    @Override
    protected long getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return this.sleepMsBetweenRetries;
    }
}

