/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit5;

import org.apache.sling.testing.mock.osgi.junit5.OsgiContext;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContextExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

final class OsgiContextStore {
    private static final ExtensionContext.Namespace OSGi_CONTEXT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{OsgiContextExtension.class});

    private OsgiContextStore() {
    }

    public static OsgiContext getOsgiContext(ExtensionContext extensionContext, Object testInstance) {
        return (OsgiContext)((Object)OsgiContextStore.getStore(extensionContext).get(testInstance, OsgiContext.class));
    }

    public static OsgiContext getOrCreateOsgiContext(ExtensionContext extensionContext, Object testInstance) {
        OsgiContext context = OsgiContextStore.getOsgiContext(extensionContext, testInstance);
        if (context == null) {
            context = OsgiContextStore.createOsgiContext(extensionContext);
            OsgiContextStore.storeOsgiContext(extensionContext, testInstance, context);
        }
        return context;
    }

    public static void removeOsgiContext(ExtensionContext extensionContext, Object testInstance) {
        OsgiContextStore.getStore(extensionContext).remove(testInstance);
    }

    public static void storeOsgiContext(ExtensionContext extensionContext, Object testInstance, OsgiContext osgiContext) {
        OsgiContextStore.getStore(extensionContext).put(testInstance, (Object)osgiContext);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(OSGi_CONTEXT_NAMESPACE);
    }

    private static OsgiContext createOsgiContext(ExtensionContext extensionContext) {
        OsgiContext osgiContext = new OsgiContext();
        osgiContext.setUpContext();
        return osgiContext;
    }
}

