/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.ConfigAnnotationUtil;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeContext;
import org.apache.sling.testing.mock.osgi.config.annotations.AutoConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigCollection;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfig;
import org.apache.sling.testing.mock.osgi.junit5.CollectConfigTypes;
import org.apache.sling.testing.mock.osgi.junit5.ConfigCollectionImpl;
import org.apache.sling.testing.mock.osgi.junit5.ConfigMap;
import org.apache.sling.testing.mock.osgi.junit5.OsgiConfigParametersStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class OsgiConfigParametersExtension
implements ParameterResolver,
BeforeEachCallback {
    private static final ConfigAnnotationUtil.ConfigTypePredicate DEFAULT_CONFIG_TYPE_PREDICATE = (parent, configType) -> !configType.getPackageName().startsWith("org.junit");

    private static ConfigTypeContext getConfigTypeContext(@NotNull ExtensionContext extensionContext) {
        return new ConfigTypeContext(OsgiConfigParametersStore.getOrCreateOsgiContext(extensionContext, extensionContext.getRequiredTestInstance()));
    }

    static Class<?> requireSupportedParameterType(@NotNull Class<?> type) throws ParameterResolutionException {
        Class parameterType = ConfigAnnotationUtil.determineSupportedConfigType(type).orElse(null);
        if (parameterType == null) {
            throw new ParameterResolutionException("Not a supported parameter type " + String.valueOf(type));
        }
        return parameterType;
    }

    static Object requireSingleParameterValue(@NotNull Class<?> parameterType, @Nullable Object resolvedValue) throws ParameterResolutionException {
        if (!parameterType.isInstance(resolvedValue)) {
            throw new ParameterResolutionException("failed to resolve parameter value of type " + String.valueOf(parameterType) + " (value " + String.valueOf(resolvedValue) + ")");
        }
        return resolvedValue;
    }

    static Stream<SetConfig> streamUpdateConfigAnnotations(ExtensionContext extensionContext) {
        return Stream.concat(extensionContext.getParent().stream().flatMap(OsgiConfigParametersExtension::streamUpdateConfigAnnotations), extensionContext.getElement().stream().flatMap(ConfigAnnotationUtil::findUpdateConfigAnnotations));
    }

    static Stream<Annotation> streamUnboundTypedConfigAnnotations(@NotNull ConfigTypeContext context, @NotNull ExtensionContext extensionContext) {
        return Stream.concat(extensionContext.getParent().stream().flatMap(parentContext -> OsgiConfigParametersExtension.streamUnboundTypedConfigAnnotations(context, parentContext)), extensionContext.getElement().stream().flatMap(element -> ConfigAnnotationUtil.findConfigTypeAnnotations((AnnotatedElement)element, DEFAULT_CONFIG_TYPE_PREDICATE.and((annotation, configType) -> annotation.map(some -> context.getConfigurationPid(some.pid(), some.component())).isEmpty())::test)));
    }

    Optional<AutoConfig> findAutoConfig(ExtensionContext extensionContext) {
        return extensionContext.getElement().map(element -> element.getAnnotation(AutoConfig.class)).or(() -> extensionContext.getParent().flatMap(this::findAutoConfig));
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        ConfigTypeContext context = OsgiConfigParametersExtension.getConfigTypeContext(extensionContext);
        OsgiConfigParametersExtension.streamUpdateConfigAnnotations(extensionContext).forEachOrdered(arg_0 -> ((ConfigTypeContext)context).updateConfiguration(arg_0));
        this.findAutoConfig(extensionContext).flatMap(annotation -> OsgiConfigParametersExtension.getConfigTypeContext(extensionContext).getConfigurationPid(annotation.pid(), annotation.value())).ifPresent(autoPid -> {
            HashMap accumulator = new HashMap();
            OsgiConfigParametersExtension.streamUnboundTypedConfigAnnotations(context, extensionContext).map(annotation -> context.newTypedConfig(annotation).getConfigMap()).forEachOrdered(accumulator::putAll);
            context.updateConfiguration(autoPid, accumulator);
        });
    }

    boolean isConfigCollectionParameterType(@NotNull Class<?> parameterType) {
        return ConfigCollection.class.isAssignableFrom(parameterType);
    }

    boolean isConfigMapParameterType(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        return Map.class.isAssignableFrom(parameterContext.getParameter().getType()) && this.getConfigMapParameterConfigType(parameterContext.getParameter(), extensionContext).isPresent();
    }

    boolean isSupportedConfigType(@NotNull Class<?> parameterType, @NotNull ExtensionContext extensionContext) {
        return ConfigAnnotationUtil.determineSupportedConfigType(parameterType).map(paramType -> ConfigCollectionImpl.collect(extensionContext, OsgiConfigParametersExtension.getConfigTypeContext(extensionContext)).streamConfigTypeAnnotations().anyMatch(ConfigAnnotationUtil.configTypeAnnotationFilter(DEFAULT_CONFIG_TYPE_PREDICATE.and((ann, configType) -> paramType.equals(configType))::test))).orElse(false);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return this.isConfigCollectionParameterType(parameterType) || this.isConfigMapParameterType(parameterContext, extensionContext) || this.isSupportedConfigType(parameterType, extensionContext);
    }

    Object resolveConfigCollectionParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        CollectConfigTypes configTypes = parameterContext.findAnnotation(CollectConfigTypes.class).orElse(null);
        ConfigTypeContext configTypeContext = OsgiConfigParametersExtension.getConfigTypeContext(extensionContext);
        String applyPid = Optional.ofNullable(configTypes).flatMap(annotation -> configTypeContext.getConfigurationPid(annotation.pid(), annotation.component())).orElse(null);
        ConfigAnnotationUtil.ConfigTypePredicate configTypePredicate = Optional.ofNullable(configTypes).map(ignored -> DEFAULT_CONFIG_TYPE_PREDICATE.and((parent, configType) -> parent.isPresent())::test).orElse(DEFAULT_CONFIG_TYPE_PREDICATE);
        return ConfigCollectionImpl.collect(extensionContext, configTypeContext, configTypePredicate, applyPid);
    }

    Optional<Class> getConfigMapParameterConfigType(@NotNull Parameter parameter, @NotNull ExtensionContext extensionContext) {
        return Optional.ofNullable(parameter.getAnnotation(ConfigMap.class)).map(ConfigMap::value).map(Class.class::cast).filter(ignored -> Map.class.isAssignableFrom(parameter.getType())).filter(ConfigAnnotationUtil::isValidConfigType).filter(configType -> this.isSupportedConfigType((Class<?>)configType, extensionContext));
    }

    Class<?>[] getEffectiveParameterTypes(@NotNull Executable executable, @NotNull ExtensionContext extensionContext) {
        return (Class[])Arrays.stream(executable.getParameters()).map(parameter -> this.getConfigMapParameterConfigType((Parameter)parameter, extensionContext).orElse(parameter.getType())).toArray(Class[]::new);
    }

    Object resolveConfigMapParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Object value = this.getConfigMapParameterConfigType(parameterContext.getParameter(), extensionContext).flatMap(parameterConfigType -> {
            ConfigCollectionImpl configCollection = ConfigCollectionImpl.collect(extensionContext, OsgiConfigParametersExtension.getConfigTypeContext(extensionContext));
            return ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, (Class)parameterConfigType, (Class[])this.getEffectiveParameterTypes(parameterContext.getDeclaringExecutable(), extensionContext), (int)parameterContext.getIndex());
        }).orElse(null);
        return OsgiConfigParametersExtension.requireSingleParameterValue(Map.class, value);
    }

    Object resolveConfigTypeParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean isArray = parameterContext.getParameter().getType().isArray();
        Class<?> parameterType = OsgiConfigParametersExtension.requireSupportedParameterType(parameterContext.getParameter().getType());
        ConfigCollectionImpl configCollection = ConfigCollectionImpl.collect(extensionContext, OsgiConfigParametersExtension.getConfigTypeContext(extensionContext));
        if (isArray) {
            return ConfigAnnotationUtil.resolveParameterToArray((ConfigCollection)configCollection, parameterType);
        }
        Object value = ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, parameterType, (Class[])this.getEffectiveParameterTypes(parameterContext.getDeclaringExecutable(), extensionContext), (int)parameterContext.getIndex()).orElse(null);
        return OsgiConfigParametersExtension.requireSingleParameterValue(parameterType, value);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (ConfigCollection.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return this.resolveConfigCollectionParameter(parameterContext, extensionContext);
        }
        if (Map.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return this.resolveConfigMapParameter(parameterContext, extensionContext);
        }
        return this.resolveConfigTypeParameter(parameterContext, extensionContext);
    }
}

