/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.IOException;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.JcrValueMap;
import org.apache.sling.jcr.resource.internal.NodeUtil;
import org.apache.sling.jcr.resource.internal.helper.JcrPropertyMapCacheEntry;
import org.jetbrains.annotations.NotNull;

public class JcrModifiableValueMap
extends JcrValueMap
implements ModifiableValueMap {
    public JcrModifiableValueMap(@NotNull Node node, @NotNull HelperData helper) {
        super(node, helper);
    }

    @Override
    public Object put(String aKey, Object value) {
        String key = this.checkKey(aKey);
        if (key.indexOf(47) != -1) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        if (value == null) {
            throw new NullPointerException("Value should not be null (key = " + key + ")");
        }
        this.readFully();
        Object oldValue = this.get(key);
        try {
            JcrPropertyMapCacheEntry entry = new JcrPropertyMapCacheEntry(value, this.node);
            this.cache.put(key, entry);
            String name = this.escapeKeyName(key);
            if ("jcr:mixinTypes".equals(name)) {
                NodeUtil.handleMixinTypes(this.node, entry.convertToType(String[].class, this.node, this.helper.getDynamicClassLoader()));
            } else if ("jcr:primaryType".equals(name)) {
                this.node.setPrimaryType(entry.convertToType(String.class, this.node, this.helper.getDynamicClassLoader()));
            } else if (entry.isArray()) {
                this.node.setProperty(name, entry.convertToType(Value[].class, this.node, this.helper.getDynamicClassLoader()));
            } else {
                this.node.setProperty(name, entry.convertToType(Value.class, this.node, this.helper.getDynamicClassLoader()));
            }
        }
        catch (IOException | RepositoryException re) {
            throw new IllegalArgumentException("Value of class '" + value.getClass() + "' for property '" + key + "' can't be put into node '" + this.getPath() + "'.", re);
        }
        this.valueCache.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends Object> t) {
        if (t != null) {
            for (Map.Entry<? extends String, ? extends Object> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Object remove(Object aKey) {
        String key = this.checkKey(aKey.toString());
        this.readFully();
        this.cache.remove(key);
        Object oldValue = this.valueCache.remove(key);
        try {
            String name = this.escapeKeyName(key);
            Property property = NodeUtil.getPropertyOrNull(this.node, name);
            if (property != null) {
                property.remove();
            }
        }
        catch (RepositoryException re) {
            throw new IllegalArgumentException("Property '" + key + "' can't be removed from node '" + this.getPath() + "'.", re);
        }
        return oldValue;
    }
}

