/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.metadata.sql.internal.shared.Dialect;
import org.apache.sis.metadata.sql.internal.shared.SQLBuilder;
import org.apache.sis.metadata.sql.internal.shared.Syntax;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.FeatureNaming;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.sql.ResourceDefinition;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.BinaryEncoding;
import org.apache.sis.storage.sql.feature.CRSEncoding;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.GeometryEncoding;
import org.apache.sis.storage.sql.feature.GeometryGetter;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.storage.sql.feature.SelectionClauseWriter;
import org.apache.sis.storage.sql.feature.SpatialSchema;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

public class Database<G>
extends Syntax {
    public static final String WILDCARD = "%";
    protected final DataSource source;
    protected final Map<String, Version> softwareVersions;
    final Geometries<G> geomLibrary;
    private final EnumMap<GeometryEncoding, String> geometryReaders;
    private final boolean isByteSigned;
    private final FeatureNaming<Table> tablesByNames;
    private Table[] tables;
    private SpatialSchema spatialSchema;
    final EnumSet<CRSEncoding> crsEncodings;
    private boolean hasGeometry;
    private boolean hasRaster;
    volatile boolean cannotCount;
    String catalogOfSpatialTables;
    String schemaOfSpatialTables;
    final boolean supportsCatalogs;
    final boolean supportsSchemas;
    private final boolean supportsJavaTime;
    private SelectionClauseWriter filterToSQL;
    protected final ReadWriteLock transactionLocks;
    protected final Locale contentLocale;
    public final StoreListeners listeners;
    final Cache<Integer, CoordinateReferenceSystem> cacheOfCRS;
    final WeakHashMap<CoordinateReferenceSystem, Integer> cacheOfSRID;

    protected Database(DataSource source, DatabaseMetaData metadata, Dialect dialect, Geometries<G> geomLibrary, Locale contentLocale, StoreListeners listeners, ReadWriteLock locks) throws SQLException {
        super(metadata, true);
        this.source = source;
        this.geomLibrary = geomLibrary;
        this.contentLocale = contentLocale;
        this.listeners = listeners;
        boolean unsigned = true;
        boolean wasNull = false;
        SQLFeatureNotSupportedException cause = null;
        try (ResultSet reflect = metadata.getTypeInfo();){
            while (reflect.next()) {
                if (reflect.getInt("DATA_TYPE") != -6) continue;
                unsigned = reflect.getBoolean("UNSIGNED_ATTRIBUTE");
                wasNull = reflect.wasNull();
                unsigned |= wasNull;
                if (wasNull) continue;
                break;
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            cause = e;
        }
        if (cause != null || wasNull) {
            this.warning((short)16, cause);
        }
        this.isByteSigned = !unsigned;
        this.cacheOfCRS = new Cache(7, 2L, false);
        this.cacheOfSRID = new WeakHashMap();
        this.tablesByNames = new FeatureNaming();
        this.supportsCatalogs = metadata.supportsCatalogsInDataManipulation();
        this.supportsSchemas = metadata.supportsSchemasInDataManipulation();
        this.supportsJavaTime = dialect.supportsJavaTime();
        this.crsEncodings = EnumSet.noneOf(CRSEncoding.class);
        this.geometryReaders = new EnumMap(GeometryEncoding.class);
        this.transactionLocks = dialect.supportsConcurrency() ? null : locks;
        this.softwareVersions = new LinkedHashMap<String, Version>(4);
        String product = Strings.trimOrNull((String)metadata.getDatabaseProductName());
        String version = Strings.trimOrNull((String)metadata.getDatabaseProductVersion());
        if (product != null || version != null) {
            this.softwareVersions.put(product, version != null ? new Version(version) : null);
        }
    }

    public final Map<String, Version> getDatabaseSoftwareVersions() {
        return Collections.unmodifiableMap(this.softwareVersions);
    }

    final Map<String, Boolean> detectSpatialSchema(DatabaseMetaData metadata, String[] tableTypes) throws SQLException {
        String crsTable = null;
        HashMap<String, Boolean> ignoredTables = new HashMap<String, Boolean>(8);
        boolean isSearchReliable = this.canEscapeWildcards();
        SpatialSchema[] candidates = this.getPossibleSpatialSchemas(ignoredTables);
        for (int i = 0; i < candidates.length; ++i) {
            SpatialSchema convention = candidates[i];
            crsTable = convention.crsTable;
            String geomTable = convention.geometryColumns;
            if (metadata.storesLowerCaseIdentifiers()) {
                crsTable = crsTable.toLowerCase(Locale.US).intern();
                geomTable = geomTable.toLowerCase(Locale.US).intern();
            } else if (metadata.storesUpperCaseIdentifiers()) {
                crsTable = crsTable.toUpperCase(Locale.US).intern();
                geomTable = geomTable.toUpperCase(Locale.US).intern();
            }
            ignoredTables.put(crsTable, null);
            ignoredTables.put(geomTable, null);
            boolean found = false;
            boolean consistent = true;
            String catalog = null;
            String schema = null;
            for (Map.Entry<String, Boolean> entry : ignoredTables.entrySet()) {
                if (i != 0 && entry.getValue() != null) continue;
                boolean exists = false;
                String table = entry.getKey();
                try (ResultSet reflect = metadata.getTables(null, null, this.escapeWildcards(table), tableTypes);){
                    while (reflect.next()) {
                        if (!isSearchReliable && !table.equals(reflect.getString("TABLE_NAME"))) continue;
                        String string = catalog;
                        catalog = reflect.getString("TABLE_CAT");
                        consistent &= Database.consistent(string, catalog);
                        String string2 = schema;
                        schema = reflect.getString("TABLE_SCHEM");
                        consistent &= Database.consistent(string2, schema);
                        found |= !Boolean.FALSE.equals(entry.getValue());
                        exists = true;
                    }
                }
                entry.setValue(exists);
            }
            if (found) {
                this.spatialSchema = convention;
                if (!consistent) break;
                this.catalogOfSpatialTables = catalog;
                this.schemaOfSpatialTables = schema;
                break;
            }
            ignoredTables.remove(crsTable);
            ignoredTables.remove(geomTable);
        }
        if (this.spatialSchema != null) {
            block13: for (Map.Entry<CRSEncoding, String> entry : this.spatialSchema.crsDefinitionColumn.entrySet()) {
                String column = entry.getValue();
                if (metadata.storesLowerCaseIdentifiers()) {
                    column = column.toLowerCase(Locale.US);
                }
                try (ResultSet reflect = metadata.getColumns(this.catalogOfSpatialTables, this.escapeWildcards(this.schemaOfSpatialTables), this.escapeWildcards(crsTable), this.escapeWildcards(column));){
                    while (reflect.next()) {
                        if (!isSearchReliable && !Database.filterMetadata(reflect, this.schemaOfSpatialTables, crsTable, column)) continue;
                        this.crsEncodings.add(entry.getKey());
                        continue block13;
                    }
                }
            }
        }
        return ignoredTables;
    }

    private static boolean consistent(String oldName, String newName) {
        return oldName == null || oldName.equals(newName);
    }

    public final void analyze(SQLStore store, Analyzer analyzer, GenericName[] tableNames, ResourceDefinition[] queries, SchemaModifier customizer, InfoStatements spatialInformation) throws Exception {
        if (this.spatialSchema != null) {
            analyzer.spatialInformation = spatialInformation;
        }
        analyzer.customizer = customizer;
        List<Table> tableList = analyzer.findFeatureTables(tableNames, queries);
        for (Table table : analyzer.finish()) {
            this.tablesByNames.add((DataStore)store, table.featureType.getName(), (Object)table);
            this.hasGeometry |= table.hasGeometry;
            this.hasRaster |= table.hasRaster;
        }
        this.tables = (Table[])tableList.toArray(Table[]::new);
    }

    final void setGeometryEncodingFunctions(String[][] accessors) {
        GeometryEncoding.store(accessors, this.geometryReaders);
    }

    public final void metadata(DatabaseMetaData metadata, MetadataBuilder builder) throws SQLException {
        builder.addPresentationForm(PresentationForm.TABLE_DIGITAL);
        builder.addSpatialRepresentation(SpatialRepresentationType.TEXT_TABLE);
        if (this.hasGeometry) {
            builder.addSpatialRepresentation(SpatialRepresentationType.VECTOR);
        }
        if (this.hasRaster) {
            builder.addSpatialRepresentation(SpatialRepresentationType.GRID);
        }
        for (Table table : this.tables) {
            builder.addFeatureType(table.featureType, table.countRows(metadata, false, false));
        }
        builder.addFormatName((CharSequence)(this.spatialSchema != null ? this.spatialSchema.name : "SQL database"));
        CharSequence description = null;
        for (Map.Entry<String, Version> entry : this.softwareVersions.entrySet()) {
            Version version;
            CharSequence software = entry.getKey();
            if (software == null) {
                software = "?";
            }
            if ((version = entry.getValue()) != null) {
                software = Vocabulary.formatInternational((short)218, (Object[])new Object[]{software, version});
            }
            if (description == null) {
                description = software;
                continue;
            }
            description = Vocabulary.formatInternational((short)277, (Object[])new Object[]{description, software});
        }
        builder.addFormatCitationDetails(description);
        builder.addFormatReaderSIS("SQL");
    }

    public final List<FeatureSet> tables() {
        return UnmodifiableArrayList.wrap((Object[])this.tables);
    }

    public final FeatureSet findTable(SQLStore store, String name) throws IllegalNameException {
        return (FeatureSet)this.tablesByNames.get((DataStore)store, name);
    }

    public final void formatTableName(SQLBuilder sql, String name) {
        String schema = this.schemaOfSpatialTables;
        if (schema != null && !schema.isEmpty()) {
            String catalog = this.catalogOfSpatialTables;
            if (catalog != null && !catalog.isEmpty()) {
                sql.appendIdentifier(catalog).append('.');
            }
            sql.appendIdentifier(schema).append('.');
        }
        sql.append(name);
    }

    static boolean filterMetadata(ResultSet reflect, String schema, String table, String column) throws SQLException {
        return !(!Strings.isNullOrEmpty((String)schema) && !schema.equals(reflect.getString("TABLE_SCHEM")) || !Strings.isNullOrEmpty((String)table) && !table.equals(reflect.getString("TABLE_NAME")) || !Strings.isNullOrEmpty((String)column) && !column.equals(reflect.getString("COLUMN_NAME")));
    }

    public final Optional<SpatialSchema> getSpatialSchema() {
        return Optional.ofNullable(this.spatialSchema);
    }

    public final CoordinateReferenceSystem getCachedCRS(int srid) {
        return (CoordinateReferenceSystem)this.cacheOfCRS.get((Object)srid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCachedSRID(CoordinateReferenceSystem crs) {
        WeakHashMap<CoordinateReferenceSystem, Integer> weakHashMap = this.cacheOfSRID;
        synchronized (weakHashMap) {
            return this.cacheOfSRID.get(crs);
        }
    }

    protected final ValueGetter<?> forGeometry(Column columnDefinition) {
        GeometryType type = columnDefinition.getGeometryType().orElse(GeometryType.GEOMETRY);
        Class geometryClass = this.geomLibrary.getGeometryClass(type).asSubclass(this.geomLibrary.rootClass);
        return new GeometryGetter(this.geomLibrary, geometryClass, columnDefinition.getDefaultCRS().orElse(null), this.getBinaryEncoding(columnDefinition), columnDefinition.getGeometryEncoding());
    }

    protected ValueGetter<?> getMapping(Column columnDefinition) {
        if (GeometryType.isKnown((String)columnDefinition.typeName)) {
            return this.forGeometry(columnDefinition);
        }
        switch (columnDefinition.type) {
            case -7: 
            case 16: {
                return ValueGetter.AsBoolean.INSTANCE;
            }
            case -6: {
                if (this.isByteSigned) {
                    return ValueGetter.AsByte.INSTANCE;
                }
            }
            case 5: {
                return ValueGetter.AsShort.INSTANCE;
            }
            case 4: {
                return ValueGetter.AsInteger.INSTANCE;
            }
            case -5: {
                return ValueGetter.AsLong.INSTANCE;
            }
            case 7: {
                return ValueGetter.AsFloat.INSTANCE;
            }
            case 6: 
            case 8: {
                return ValueGetter.AsDouble.INSTANCE;
            }
            case 2: 
            case 3: {
                return ValueGetter.AsBigDecimal.INSTANCE;
            }
            case -1: 
            case 1: 
            case 12: {
                return ValueGetter.AsString.INSTANCE;
            }
            case 91: {
                return this.supportsJavaTime ? ValueGetter.LOCAL_DATE : ValueGetter.AsLocalDate.INSTANCE;
            }
            case 92: {
                return this.supportsJavaTime ? ValueGetter.LOCAL_TIME : ValueGetter.AsLocalTime.INSTANCE;
            }
            case 93: {
                return this.supportsJavaTime ? ValueGetter.LOCAL_DATE_TIME : ValueGetter.AsLocalDateTime.INSTANCE;
            }
            case 2013: {
                return this.supportsJavaTime ? ValueGetter.OFFSET_TIME : ValueGetter.AsOffsetTime.INSTANCE;
            }
            case 2014: {
                return this.supportsJavaTime ? ValueGetter.OFFSET_DATE_TIME : ValueGetter.AsOffsetDateTime.INSTANCE;
            }
            case 2004: {
                return ValueGetter.AsBytes.INSTANCE;
            }
            case 1111: 
            case 2000: {
                return this.getDefaultMapping();
            }
            case -4: 
            case -3: 
            case -2: {
                BinaryEncoding encoding = this.getBinaryEncoding(columnDefinition);
                switch (encoding) {
                    case RAW: {
                        return ValueGetter.AsBytes.INSTANCE;
                    }
                    case HEXADECIMAL: {
                        return ValueGetter.AsBytes.HEXADECIMAL;
                    }
                }
                throw new AssertionError((Object)encoding);
            }
            case 2003: {
                int componentType = this.getArrayComponentType(columnDefinition);
                ValueGetter<?> component = this.getMapping(new Column(componentType, columnDefinition.typeName));
                if (component == ValueGetter.AsObject.INSTANCE) {
                    return ValueGetter.AsArray.INSTANCE;
                }
                return new ValueGetter.AsArray(component);
            }
        }
        return null;
    }

    protected ValueGetter<Object> getDefaultMapping() {
        return ValueGetter.AsObject.INSTANCE;
    }

    protected int getArrayComponentType(Column columnDefinition) {
        return 1111;
    }

    protected BinaryEncoding getBinaryEncoding(Column columnDefinition) {
        return BinaryEncoding.RAW;
    }

    protected GeometryEncoding getGeometryEncoding(Column columnDefinition) {
        return GeometryEncoding.WKB;
    }

    protected Envelope getEstimatedExtent(TableReference table, Column[] columns, boolean recall) throws SQLException {
        return null;
    }

    protected SpatialSchema[] getPossibleSpatialSchemas(Map<String, Boolean> ignoredTables) {
        return SpatialSchema.values();
    }

    protected SelectionClauseWriter getFilterToSQL() {
        return SelectionClauseWriter.DEFAULT;
    }

    final synchronized SelectionClauseWriter getFilterToSupportedSQL() {
        if (this.filterToSQL == null) {
            this.filterToSQL = this.getFilterToSQL().removeUnsupportedFunctions(this);
        }
        return this.filterToSQL;
    }

    final String getGeometryEncodingFunction(Column column) {
        this.getFilterToSupportedSQL();
        return this.geometryReaders.get((Object)column.getGeometryEncoding());
    }

    public InfoStatements createInfoStatements(Connection connection) {
        return new InfoStatements(this, connection);
    }

    final void warning(short resourceKey, Exception cause) {
        LogRecord record = Resources.forLocale(this.listeners.getLocale()).createLogRecord(Level.WARNING, resourceKey);
        record.setThrown(cause);
        this.log(record);
    }

    protected final void log(LogRecord record) {
        record.setSourceClassName(SQLStore.class.getName());
        record.setSourceMethodName("components");
        record.setLoggerName("org.apache.sis.sql");
        this.listeners.warning(record);
    }

    final void appendTo(TreeTable.Node parent) {
        if (this.tables != null) {
            for (Table child : this.tables) {
                child.appendTo(parent);
            }
        }
    }

    public String toString() {
        return TableReference.toString((Object)this, n -> this.appendTo((TreeTable.Node)n));
    }
}

