/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bundle;

import java.io.File;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.apache.nifi.bundle.BundleCoordinate;

public class BundleDetails {
    private final File workingDirectory;
    private final BundleCoordinate coordinate;
    private final BundleCoordinate dependencyCoordinate;
    private final String buildTag;
    private final String buildRevision;
    private final String buildBranch;
    private final String buildTimestamp;
    private final String buildJdk;
    private final String builtBy;

    private BundleDetails(Builder builder) {
        this.workingDirectory = builder.workingDirectory;
        this.coordinate = builder.coordinate;
        this.dependencyCoordinate = builder.dependencyCoordinate;
        this.buildTag = builder.buildTag;
        this.buildRevision = builder.buildRevision;
        this.buildBranch = builder.buildBranch;
        this.buildTimestamp = builder.buildTimestamp;
        this.buildJdk = builder.buildJdk;
        this.builtBy = builder.builtBy;
        if (this.coordinate == null) {
            if (this.workingDirectory == null) {
                throw new IllegalStateException("Coordinate cannot be null");
            }
            throw new IllegalStateException("Coordinate cannot be null for " + this.workingDirectory.getAbsolutePath());
        }
        if (this.workingDirectory == null) {
            throw new IllegalStateException("Working directory cannot be null for " + this.coordinate.getId());
        }
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public BundleCoordinate getCoordinate() {
        return this.coordinate;
    }

    public BundleCoordinate getDependencyCoordinate() {
        return this.dependencyCoordinate;
    }

    public String getBuildTag() {
        return this.buildTag;
    }

    public String getBuildRevision() {
        return this.buildRevision;
    }

    public String getBuildBranch() {
        return this.buildBranch;
    }

    public String getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getBuildJdk() {
        return this.buildJdk;
    }

    public String getBuiltBy() {
        return this.builtBy;
    }

    public String toString() {
        return this.coordinate.toString();
    }

    public Date getBuildTimestampDate() {
        if (this.buildTimestamp != null && !this.buildTimestamp.isEmpty()) {
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return Date.from(OffsetDateTime.parse(this.buildTimestamp, dateTimeFormatter).toInstant());
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }
        return null;
    }

    public static class Builder {
        private File workingDirectory;
        private BundleCoordinate coordinate;
        private BundleCoordinate dependencyCoordinate;
        private String buildTag;
        private String buildRevision;
        private String buildBranch;
        private String buildTimestamp;
        private String buildJdk;
        private String builtBy;

        public Builder workingDir(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder coordinate(BundleCoordinate coordinate) {
            this.coordinate = coordinate;
            return this;
        }

        public Builder dependencyCoordinate(BundleCoordinate dependencyCoordinate) {
            this.dependencyCoordinate = dependencyCoordinate;
            return this;
        }

        public Builder buildTag(String buildTag) {
            this.buildTag = buildTag;
            return this;
        }

        public Builder buildRevision(String buildRevision) {
            this.buildRevision = buildRevision;
            return this;
        }

        public Builder buildBranch(String buildBranch) {
            this.buildBranch = buildBranch;
            return this;
        }

        public Builder buildTimestamp(String buildTimestamp) {
            this.buildTimestamp = buildTimestamp;
            return this;
        }

        public Builder buildJdk(String buildJdk) {
            this.buildJdk = buildJdk;
            return this;
        }

        public Builder builtBy(String builtBy) {
            this.builtBy = builtBy;
            return this;
        }

        public BundleDetails build() {
            return new BundleDetails(this);
        }
    }
}

