/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Objects;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public final class JavaSerializationHint
implements ConditionalHint {
    private final TypeReference type;
    @Nullable
    private final TypeReference reachableType;

    JavaSerializationHint(Builder builder) {
        this.type = builder.type;
        this.reachableType = builder.reachableType;
    }

    public TypeReference getType() {
        return this.type;
    }

    @Override
    @Nullable
    public TypeReference getReachableType() {
        return this.reachableType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof JavaSerializationHint)) return false;
        JavaSerializationHint that = (JavaSerializationHint)other;
        if (!this.type.equals(that.type)) return false;
        if (!Objects.equals(this.reachableType, that.reachableType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.reachableType);
    }

    public static class Builder {
        private final TypeReference type;
        @Nullable
        private TypeReference reachableType;

        Builder(TypeReference type) {
            this.type = type;
        }

        public Builder onReachableType(TypeReference reachableType) {
            this.reachableType = reachableType;
            return this;
        }

        JavaSerializationHint build() {
            return new JavaSerializationHint(this);
        }
    }
}

