/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.session;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.toolkit.cli.api.Session;

public class InMemorySession
implements Session {
    private static final String NIFI_CLIENT_ID = UUID.randomUUID().toString();
    private Map<String, String> variables = new ConcurrentHashMap<String, String>();

    @Override
    public String getNiFiClientID() {
        return NIFI_CLIENT_ID;
    }

    @Override
    public void set(String variable, String value) {
        if (variable == null) {
            throw new IllegalArgumentException("Variable cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.variables.put(variable, value.trim());
    }

    @Override
    public String get(String variable) {
        return this.variables.get(variable);
    }

    @Override
    public void remove(String variable) {
        this.variables.remove(variable);
    }

    @Override
    public void clear() {
        this.variables.clear();
    }

    @Override
    public Set<String> keys() {
        return new HashSet<String>(this.variables.keySet());
    }

    @Override
    public void printVariables(PrintStream output) {
        output.println();
        output.println("Current Session:");
        output.println();
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            output.println(entry.getKey() + " = " + entry.getValue());
        }
        output.println();
    }
}

