/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.AbstractOpenPGPKeySignatureGenerator;
import org.bouncycastle.openpgp.api.KeyPairGeneratorCallback;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.SignatureParameters;
import org.bouncycastle.openpgp.api.Utils;
import org.bouncycastle.openpgp.api.exception.OpenPGPKeyException;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;

public class OpenPGPKeyEditor
extends AbstractOpenPGPKeySignatureGenerator {
    private final OpenPGPImplementation implementation;
    private final OpenPGPPolicy policy;
    private OpenPGPKey key;
    private final OpenPGPKey.OpenPGPPrivateKey primaryKey;

    public OpenPGPKeyEditor(OpenPGPKey openPGPKey, KeyPassphraseProvider keyPassphraseProvider) throws PGPException {
        this(openPGPKey, keyPassphraseProvider, openPGPKey.implementation);
    }

    public OpenPGPKeyEditor(OpenPGPKey openPGPKey, KeyPassphraseProvider keyPassphraseProvider, OpenPGPImplementation openPGPImplementation) throws PGPException {
        this(openPGPKey, keyPassphraseProvider, openPGPImplementation, openPGPImplementation.policy());
    }

    public OpenPGPKeyEditor(OpenPGPKey openPGPKey, KeyPassphraseProvider keyPassphraseProvider, OpenPGPImplementation openPGPImplementation, OpenPGPPolicy openPGPPolicy) throws PGPException {
        this.key = openPGPKey;
        this.primaryKey = openPGPKey.getPrimarySecretKey().unlock(keyPassphraseProvider);
        this.implementation = openPGPImplementation;
        this.policy = openPGPPolicy;
    }

    public OpenPGPKeyEditor addDirectKeySignature(SignatureParameters.Callback callback) throws PGPException {
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.directKeySignature(this.policy));
        if (signatureParameters != null) {
            PGPPublicKey pGPPublicKey = this.key.getPrimaryKey().getPGPPublicKey();
            PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, pGPPublicKey, this.primaryKey.getKeyPair().getPrivateKey(), signatureParameters, signatureParameters.getSignatureCreationTime(), null);
            PGPPublicKey pGPPublicKey2 = Utils.injectCertification(pGPPublicKey, pGPSignatureGenerator);
            this.key = this.generateOpenPGPKey(pGPPublicKey2);
        }
        return this;
    }

    public OpenPGPKeyEditor addUserId(String string) throws PGPException {
        return this.addUserId(string, null);
    }

    public OpenPGPKeyEditor addUserId(String string, SignatureParameters.Callback callback) throws PGPException {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("User-ID cannot be null or empty.");
        }
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.certification(this.policy));
        if (signatureParameters != null) {
            PGPPublicKey pGPPublicKey = this.key.getPrimaryKey().getPGPPublicKey();
            PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, pGPPublicKey, this.primaryKey.getKeyPair().getPrivateKey(), signatureParameters, signatureParameters.getSignatureCreationTime(), null);
            this.key = this.generateOpenPGPKey(Utils.injectCertification(string, pGPPublicKey, pGPSignatureGenerator));
        }
        return this;
    }

    public OpenPGPKeyEditor revokeIdentity(OpenPGPCertificate.OpenPGPIdentityComponent openPGPIdentityComponent) throws PGPException {
        return this.revokeIdentity(openPGPIdentityComponent, null);
    }

    public OpenPGPKeyEditor revokeIdentity(OpenPGPCertificate.OpenPGPIdentityComponent openPGPIdentityComponent, SignatureParameters.Callback callback) throws PGPException {
        if (!this.key.getComponents().contains(openPGPIdentityComponent)) {
            throw new IllegalArgumentException("UserID or UserAttribute is not part of the certificate.");
        }
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.certificationRevocation(this.policy));
        if (signatureParameters != null) {
            PGPPublicKey pGPPublicKey;
            PGPPublicKey pGPPublicKey2 = this.key.getPrimaryKey().getPGPPublicKey();
            PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, pGPPublicKey2, this.primaryKey.getKeyPair().getPrivateKey(), signatureParameters, signatureParameters.getSignatureCreationTime(), null);
            if (openPGPIdentityComponent instanceof OpenPGPCertificate.OpenPGPUserId) {
                OpenPGPCertificate.OpenPGPUserId openPGPUserId = (OpenPGPCertificate.OpenPGPUserId)openPGPIdentityComponent;
                pGPPublicKey = Utils.injectCertification(openPGPUserId.getUserId(), pGPPublicKey2, pGPSignatureGenerator);
            } else {
                OpenPGPCertificate.OpenPGPUserAttribute openPGPUserAttribute = (OpenPGPCertificate.OpenPGPUserAttribute)openPGPIdentityComponent;
                PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(openPGPUserAttribute.getUserAttribute(), pGPPublicKey2);
                pGPPublicKey = PGPPublicKey.addCertification(pGPPublicKey2, openPGPUserAttribute.getUserAttribute(), pGPSignature);
            }
            this.key = this.generateOpenPGPKey(pGPPublicKey);
        }
        return this;
    }

    public OpenPGPKeyEditor addEncryptionSubkey() throws PGPException {
        return this.addEncryptionSubkey(KeyPairGeneratorCallback.Util.encryptionKey());
    }

    public OpenPGPKeyEditor addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
        return this.addEncryptionSubkey(keyPairGeneratorCallback, this.key.getPrimaryKey().getVersion(), new Date());
    }

    public OpenPGPKeyEditor addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, int n, Date date) throws PGPException {
        PGPKeyPairGenerator pGPKeyPairGenerator = this.implementation.pgpKeyPairGeneratorProvider().get(n, date);
        return this.addEncryptionSubkey(keyPairGeneratorCallback.generateFrom(pGPKeyPairGenerator), null);
    }

    public OpenPGPKeyEditor addEncryptionSubkey(PGPKeyPair pGPKeyPair, SignatureParameters.Callback callback) throws PGPException {
        if (!pGPKeyPair.getPublicKey().isEncryptionKey()) {
            throw new PGPKeyValidationException("Provided subkey is not encryption-capable.");
        }
        this.updateKey(pGPKeyPair, callback, this.key.getPrimaryKey().getPGPPublicKey(), new Utils.HashedSubpacketsOperation(){

            @Override
            public void operate(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
                pGPSignatureSubpacketGenerator.setKeyFlags(12);
            }
        });
        return this;
    }

    public OpenPGPKeyEditor addSigningSubkey() throws PGPException {
        return this.addSigningSubkey(KeyPairGeneratorCallback.Util.signingKey());
    }

    public OpenPGPKeyEditor addSigningSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
        return this.addSigningSubkey(keyPairGeneratorCallback, this.key.getPrimaryKey().getVersion(), new Date());
    }

    public OpenPGPKeyEditor addSigningSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, int n, Date date) throws PGPException {
        PGPKeyPairGenerator pGPKeyPairGenerator = this.implementation.pgpKeyPairGeneratorProvider().get(n, date);
        return this.addSigningSubkey(keyPairGeneratorCallback.generateFrom(pGPKeyPairGenerator), null, null);
    }

    public OpenPGPKeyEditor addSigningSubkey(PGPKeyPair pGPKeyPair, SignatureParameters.Callback callback, SignatureParameters.Callback callback2) throws PGPException {
        if (!PublicKeyUtils.isSigningAlgorithm(pGPKeyPair.getPublicKey().getAlgorithm())) {
            throw new PGPKeyValidationException("Provided subkey is not signing-capable.");
        }
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback2, SignatureParameters.primaryKeyBinding(this.policy));
        PGPPublicKey pGPPublicKey = this.key.getPrimaryKey().getPGPPublicKey();
        final PGPSignature pGPSignature = Utils.getBackSignature(pGPKeyPair, signatureParameters, pGPPublicKey, this.implementation, null);
        this.updateKey(pGPKeyPair, callback, pGPPublicKey, new Utils.HashedSubpacketsOperation(){
            final /* synthetic */ OpenPGPKeyEditor this$0;
            {
                this.this$0 = openPGPKeyEditor;
            }

            @Override
            public void operate(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
                pGPSignatureSubpacketGenerator.setKeyFlags(2);
                Utils.addEmbeddedSiganture(pGPSignature, pGPSignatureSubpacketGenerator);
            }
        });
        return this;
    }

    public OpenPGPKeyEditor addSubkey(PGPKeyPair pGPKeyPair, SignatureParameters.Callback callback, SignatureParameters.Callback callback2) throws PGPException {
        if (PublicKeyUtils.isSigningAlgorithm(pGPKeyPair.getPublicKey().getAlgorithm()) && callback2 != null) {
            throw new PGPKeyValidationException("Provided subkey is not signing-capable, so we cannot create a back-signature.");
        }
        PGPPublicKey pGPPublicKey = pGPKeyPair.getPublicKey();
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback2, SignatureParameters.primaryKeyBinding(this.policy));
        PGPPublicKey pGPPublicKey2 = this.key.getPrimaryKey().getPGPPublicKey();
        final PGPSignature pGPSignature = Utils.getBackSignature(pGPKeyPair, signatureParameters, pGPPublicKey2, this.implementation, null);
        SignatureParameters signatureParameters2 = Utils.applySignatureParameters(callback, SignatureParameters.subkeyBinding(this.policy));
        if (signatureParameters2 != null) {
            PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, pGPPublicKey2, this.primaryKey.getKeyPair().getPrivateKey(), signatureParameters2, signatureParameters2.getSignatureCreationTime(), new Utils.HashedSubpacketsOperation(){
                final /* synthetic */ OpenPGPKeyEditor this$0;
                {
                    this.this$0 = openPGPKeyEditor;
                }

                @Override
                public void operate(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
                    Utils.addEmbeddedSiganture(pGPSignature, pGPSignatureSubpacketGenerator);
                }
            });
            pGPPublicKey = Utils.injectCertification(pGPPublicKey, pGPSignatureGenerator, pGPPublicKey2);
        }
        this.key = this.generateOpenPGPKey(pGPKeyPair, pGPPublicKey);
        return this;
    }

    public OpenPGPKeyEditor revokeComponentKey(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey) throws PGPException {
        return this.revokeComponentKey(openPGPComponentKey, null);
    }

    public OpenPGPKeyEditor revokeComponentKey(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, SignatureParameters.Callback callback) throws PGPException {
        boolean bl;
        boolean bl2 = bl = this.key.getKey(openPGPComponentKey.getKeyIdentifier()) != null;
        if (!bl) {
            throw new IllegalArgumentException("Provided component key is not part of the OpenPGP key.");
        }
        boolean bl3 = !openPGPComponentKey.getKeyIdentifier().equals(this.key.getKeyIdentifier());
        SignatureParameters signatureParameters = bl3 ? SignatureParameters.subkeyRevocation(this.policy) : SignatureParameters.keyRevocation(this.policy);
        signatureParameters = Utils.applySignatureParameters(callback, signatureParameters);
        PGPPublicKey pGPPublicKey = this.key.getPrimaryKey().getPGPPublicKey();
        PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, pGPPublicKey, this.primaryKey.getKeyPair().getPrivateKey(), signatureParameters, signatureParameters.getSignatureCreationTime(), null);
        pGPPublicKey = bl3 ? Utils.injectCertification(openPGPComponentKey.getPGPPublicKey(), pGPSignatureGenerator, pGPPublicKey) : Utils.injectCertification(pGPPublicKey, pGPSignatureGenerator);
        this.key = this.generateOpenPGPKey(pGPPublicKey);
        return this;
    }

    public OpenPGPKeyEditor revokeKey() throws PGPException {
        return this.revokeKey(null);
    }

    public OpenPGPKeyEditor revokeKey(SignatureParameters.Callback callback) throws PGPException {
        return this.revokeComponentKey(this.key.getPrimaryKey(), callback);
    }

    public OpenPGPKeyEditor changePassphrase(KeyIdentifier keyIdentifier, char[] cArray, char[] cArray2, boolean bl) throws OpenPGPKeyException, PGPException {
        OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = this.key.getSecretKey(keyIdentifier);
        if (openPGPSecretKey == null) {
            throw new OpenPGPKeyException(this.key, "Secret component key " + keyIdentifier + " is missing from the key.");
        }
        OpenPGPKey.OpenPGPPrivateKey openPGPPrivateKey = openPGPSecretKey.unlock(cArray);
        openPGPSecretKey = openPGPPrivateKey.changePassphrase(cArray2, this.implementation, bl);
        this.key.replaceSecretKey(openPGPSecretKey);
        return this;
    }

    public OpenPGPKey done() {
        return this.key;
    }

    private OpenPGPKey generateOpenPGPKey(PGPPublicKey pGPPublicKey) {
        PGPPublicKeyRing pGPPublicKeyRing = PGPPublicKeyRing.insertPublicKey(this.key.getPGPPublicKeyRing(), pGPPublicKey);
        PGPSecretKeyRing pGPSecretKeyRing = PGPSecretKeyRing.replacePublicKeys(this.key.getPGPKeyRing(), pGPPublicKeyRing);
        return new OpenPGPKey(pGPSecretKeyRing, this.implementation, this.policy);
    }

    private OpenPGPKey generateOpenPGPKey(PGPKeyPair pGPKeyPair, PGPPublicKey pGPPublicKey) throws PGPException {
        PGPSecretKey pGPSecretKey = new PGPSecretKey(pGPKeyPair.getPrivateKey(), pGPPublicKey, this.implementation.pgpDigestCalculatorProvider().get(2), false, null);
        PGPSecretKeyRing pGPSecretKeyRing = PGPSecretKeyRing.insertSecretKey(this.key.getPGPKeyRing(), pGPSecretKey);
        return new OpenPGPKey(pGPSecretKeyRing, this.implementation, this.policy);
    }

    private void updateKey(PGPKeyPair pGPKeyPair, SignatureParameters.Callback callback, PGPPublicKey pGPPublicKey, Utils.HashedSubpacketsOperation hashedSubpacketsOperation) throws PGPException {
        SignatureParameters signatureParameters = Utils.applySignatureParameters(callback, SignatureParameters.subkeyBinding(this.policy));
        if (signatureParameters != null) {
            PGPSignatureGenerator pGPSignatureGenerator = Utils.getPgpSignatureGenerator(this.implementation, pGPPublicKey, this.primaryKey.getKeyPair().getPrivateKey(), signatureParameters, signatureParameters.getSignatureCreationTime(), hashedSubpacketsOperation);
            PGPPublicKey pGPPublicKey2 = Utils.injectCertification(pGPKeyPair.getPublicKey(), pGPSignatureGenerator, pGPPublicKey);
            this.key = this.generateOpenPGPKey(pGPKeyPair, pGPPublicKey2);
        }
    }
}

