/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.WrapTokenId;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.JoinToken;
import org.netbeans.lib.lexer.token.PartToken;
import org.netbeans.spi.lexer.TokenPropertyProvider;

public class JoinLexerInputOperation<T extends TokenId>
extends LexerInputOperation<T> {
    CharSequence inputSourceText;
    private TokenListText readText;
    private TokenListText readExistingText;
    private EmbeddedTokenList<?, T> activeTokenList;
    private int activeTokenListIndex;
    private int activeTokenListEndOffset;
    private int realTokenStartOffset;
    private boolean recognizedTokenJoined;
    private int skipTokenListCount;

    public JoinLexerInputOperation(JoinTokenList<T> joinTokenList, int relexJoinIndex, Object lexerRestartState, int activeTokenListIndex, int relexOffset) {
        super(joinTokenList, relexJoinIndex, lexerRestartState);
        this.inputSourceText = joinTokenList.inputSourceText();
        this.activeTokenListIndex = activeTokenListIndex;
        this.tokenStartOffset = relexOffset;
        this.readOffset = relexOffset;
    }

    public final void init() {
        this.fetchActiveTokenList();
        this.readText = new TokenListText(this.activeTokenListIndex);
        this.realTokenStartOffset = this.readOffset;
    }

    public EmbeddedTokenList<?, T> activeTokenList() {
        return this.activeTokenList;
    }

    public int activeTokenListIndex() {
        return this.activeTokenListIndex;
    }

    public int skipTokenListCount() {
        return this.skipTokenListCount;
    }

    public void clearSkipTokenListCount() {
        this.skipTokenListCount = 0;
    }

    public boolean recognizedTokenLastInTokenList() {
        return this.realTokenStartOffset == this.activeTokenListEndOffset;
    }

    @Override
    public int lastTokenEndOffset() {
        return this.realTokenStartOffset;
    }

    @Override
    public int read(int offset) {
        return this.readText.read(offset);
    }

    @Override
    public char readExisting(int offset) {
        if (this.readText.isInBounds(offset)) {
            return this.readText.inBoundsChar(offset);
        }
        if (this.readExistingText == null) {
            this.readExistingText = new TokenListText(this.readText);
        }
        return this.readExistingText.existingChar(offset);
    }

    @Override
    public void assignTokenLength(int tokenLength) {
        super.assignTokenLength(tokenLength);
        if (this.recognizedTokenLastInTokenList()) {
            do {
                ++this.skipTokenListCount;
                ++this.activeTokenListIndex;
                this.fetchActiveTokenList();
            } while (this.realTokenStartOffset == this.activeTokenListEndOffset);
        }
        this.realTokenStartOffset += tokenLength;
        this.recognizedTokenJoined = this.realTokenStartOffset > this.activeTokenListEndOffset;
    }

    private void fetchActiveTokenList() {
        this.activeTokenList = this.tokenList(this.activeTokenListIndex);
        this.activeTokenList.updateModCount();
        this.realTokenStartOffset = this.activeTokenList.startOffset();
        this.activeTokenListEndOffset = this.activeTokenList.endOffset();
    }

    public EmbeddedTokenList<?, T> tokenList(int tokenListIndex) {
        return ((JoinTokenList)this.tokenList).tokenList(tokenListIndex);
    }

    protected int tokenListCount() {
        return ((JoinTokenList)this.tokenList).tokenListCount();
    }

    @Override
    protected void fillTokenData(AbstractToken<T> token) {
        if (!this.recognizedTokenJoined) {
            token.setRawOffset(this.realTokenStartOffset - this.tokenLength);
        }
    }

    @Override
    protected boolean isFlyTokenAllowed() {
        return super.isFlyTokenAllowed() && !this.recognizedTokenJoined;
    }

    @Override
    protected AbstractToken<T> createDefaultTokenInstance(T id) {
        if (this.recognizedTokenJoined) {
            return this.createJoinToken(id, null, PartType.COMPLETE);
        }
        return super.createDefaultTokenInstance(id);
    }

    @Override
    protected AbstractToken<T> createPropertyTokenInstance(T id, TokenPropertyProvider<T> propertyProvider, PartType partType) {
        if (this.recognizedTokenJoined) {
            return this.createJoinToken(id, propertyProvider, partType);
        }
        return super.createPropertyTokenInstance(id, propertyProvider, partType);
    }

    private AbstractToken<T> createJoinToken(T id, TokenPropertyProvider<T> propertyProvider, PartType partType) {
        this.realTokenStartOffset -= this.tokenLength;
        WrapTokenId<T> wid = this.wrapTokenIdCache.plainWid(id);
        JoinToken joinToken = new JoinToken(wid, this.tokenLength, propertyProvider, partType);
        int joinPartCountEstimate = this.readText.tokenListIndex - this.activeTokenListIndex + 1;
        PartToken[] parts = new PartToken[joinPartCountEstimate];
        int partLength = this.activeTokenListEndOffset - this.realTokenStartOffset;
        PartToken<T> partToken = new PartToken<T>(wid, partLength, propertyProvider, PartType.START, joinToken, 0, 0);
        partToken.setRawOffset(this.realTokenStartOffset);
        parts[0] = partToken;
        int partIndex = 1;
        int partTextOffset = partLength;
        int firstPartTokenListIndex = this.activeTokenListIndex;
        do {
            PartType partPartType;
            ++this.activeTokenListIndex;
            this.fetchActiveTokenList();
            partLength = this.activeTokenListEndOffset - this.realTokenStartOffset;
            if (partLength == 0) continue;
            if (partTextOffset + partLength >= this.tokenLength) {
                partLength = this.tokenLength - partTextOffset;
                partPartType = partType == PartType.START ? PartType.MIDDLE : PartType.END;
            } else {
                partPartType = PartType.MIDDLE;
            }
            partToken = new PartToken<T>(wid, partLength, propertyProvider, partPartType, joinToken, partIndex, partTextOffset);
            partToken.setRawOffset(this.realTokenStartOffset);
            partTextOffset += partLength;
            parts[partIndex++] = partToken;
        } while (partTextOffset < this.tokenLength);
        this.realTokenStartOffset += partLength;
        if (partIndex < parts.length) {
            PartToken[] tmp = new PartToken[partIndex];
            System.arraycopy(parts, 0, tmp, 0, partIndex);
            parts = tmp;
        }
        List partList = ArrayUtilities.unmodifiableList(parts);
        joinToken.setJoinedParts(partList, this.activeTokenListIndex - firstPartTokenListIndex);
        return joinToken;
    }

    @Override
    public String toString() {
        return super.toString() + ", realTokenStartOffset=" + this.realTokenStartOffset + ", activeTokenListIndex=" + this.activeTokenListIndex + ", activeTokenListEndOffset=" + this.activeTokenListEndOffset;
    }

    final class TokenListText {
        int tokenListIndex;
        int tokenListStartOffset;
        int tokenListEndOffset;
        int readOffsetShift;

        TokenListText(int tokenListIndex) {
            this.tokenListIndex = tokenListIndex;
            EmbeddedTokenList etl = JoinLexerInputOperation.this.tokenList(tokenListIndex);
            etl.updateModCount();
            this.tokenListStartOffset = etl.startOffset();
            this.tokenListEndOffset = etl.endOffset();
            this.readOffsetShift = 0;
        }

        TokenListText(TokenListText text) {
            this.tokenListIndex = text.tokenListIndex;
            this.tokenListStartOffset = text.tokenListStartOffset;
            this.tokenListEndOffset = text.tokenListEndOffset;
            this.readOffsetShift = text.readOffsetShift;
        }

        int read(int offset) {
            if ((offset += this.readOffsetShift) < this.tokenListEndOffset) {
                if (offset >= this.tokenListStartOffset) {
                    return JoinLexerInputOperation.this.inputSourceText.charAt(offset);
                }
                while ((offset -= this.movePreviousTokenList()) < this.tokenListStartOffset) {
                }
                return JoinLexerInputOperation.this.inputSourceText.charAt(offset);
            }
            while (this.tokenListIndex + 1 < JoinLexerInputOperation.this.tokenListCount()) {
                if ((offset += this.moveNextTokenList()) >= this.tokenListEndOffset) continue;
                return JoinLexerInputOperation.this.inputSourceText.charAt(offset);
            }
            return -1;
        }

        boolean isInBounds(int offset) {
            return (offset += this.readOffsetShift) >= this.tokenListStartOffset && offset < this.tokenListEndOffset;
        }

        char inBoundsChar(int offset) {
            return JoinLexerInputOperation.this.inputSourceText.charAt(offset += this.readOffsetShift);
        }

        char existingChar(int offset) {
            if ((offset += this.readOffsetShift) < this.tokenListStartOffset) {
                while ((offset -= this.movePreviousTokenList()) < this.tokenListStartOffset) {
                }
                return JoinLexerInputOperation.this.inputSourceText.charAt(offset);
            }
            if (offset >= this.tokenListEndOffset) {
                while ((offset += this.moveNextTokenList()) >= this.tokenListEndOffset) {
                }
                return JoinLexerInputOperation.this.inputSourceText.charAt(offset);
            }
            return JoinLexerInputOperation.this.inputSourceText.charAt(offset);
        }

        private int movePreviousTokenList() {
            --this.tokenListIndex;
            EmbeddedTokenList etl = JoinLexerInputOperation.this.tokenList(this.tokenListIndex);
            etl.updateModCount();
            this.tokenListEndOffset = etl.endOffset();
            int shift = this.tokenListStartOffset - this.tokenListEndOffset;
            this.readOffsetShift -= shift;
            this.tokenListStartOffset = etl.startOffset();
            return shift;
        }

        private int moveNextTokenList() {
            ++this.tokenListIndex;
            EmbeddedTokenList etl = JoinLexerInputOperation.this.tokenList(this.tokenListIndex);
            etl.updateModCount();
            this.tokenListStartOffset = etl.startOffset();
            int shift = this.tokenListStartOffset - this.tokenListEndOffset;
            this.readOffsetShift += shift;
            this.tokenListEndOffset = etl.endOffset();
            return shift;
        }

        public String toString() {
            return "tlInd=" + this.tokenListIndex + ", <" + this.tokenListStartOffset + "," + this.tokenListEndOffset + ">";
        }
    }
}

