/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import org.apache.juneau.BeanSession;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

public class ManifestFile
extends JsonMap {
    private static final long serialVersionUID = 1L;

    public ManifestFile(Class<?> c) throws IOException {
        String className = c.getSimpleName() + ".class";
        String classPath = c.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest mf = new Manifest(new URL(manifestPath).openStream());
            this.load(mf);
        }
        catch (MalformedURLException e) {
            throw ThrowableUtils.castException(IOException.class, e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ManifestFile(File f) throws IOException {
        Manifest mf = new Manifest();
        try (FileInputStream fis = new FileInputStream(f);){
            mf.read(fis);
            this.load(mf);
        }
        catch (IOException e) {
            throw ThrowableUtils.ioex(e, "Problem detected in MANIFEST.MF.  Contents below:\n{0}", IoUtils.read(f));
        }
    }

    public ManifestFile(InputStream is) throws IOException {
        this.load(new Manifest(is));
    }

    public ManifestFile(Manifest f) {
        this.load(f);
    }

    public ManifestFile(Path path) throws IOException {
        Manifest mf = new Manifest();
        try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
            mf.read(fis);
            this.load(mf);
        }
        catch (IOException e) {
            throw ThrowableUtils.ioex(e, "Problem detected in MANIFEST.MF.  Contents below:\n{0}", IoUtils.read(path), e);
        }
    }

    public ManifestFile(Reader r) throws IOException {
        this.load(new Manifest(new ByteArrayInputStream(IoUtils.read(r).getBytes(IoUtils.UTF8))));
    }

    @Override
    public ManifestFile append(Map<String, Object> values) {
        super.append(values);
        return this;
    }

    @Override
    public ManifestFile append(String key, Object value) {
        super.append(key, value);
        return this;
    }

    @Override
    public ManifestFile appendIf(boolean flag, String key, Object value) {
        super.appendIf(flag, key, value);
        return this;
    }

    @Override
    public ManifestFile filtered(Predicate<Object> value) {
        super.filtered(value);
        return this;
    }

    @Override
    public ManifestFile inner(Map<String, Object> inner) {
        super.inner(inner);
        return this;
    }

    @Override
    public ManifestFile keepAll(String ... keys) {
        super.keepAll(keys);
        return this;
    }

    @Override
    public ManifestFile modifiable() {
        return this;
    }

    @Override
    public ManifestFile session(BeanSession session) {
        super.session(session);
        return this;
    }

    @Override
    public ManifestFile setBeanSession(BeanSession value) {
        super.setBeanSession(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach((k, v) -> sb.append((String)k).append(": ").append(v).append("\n"));
        return sb.toString();
    }

    @Override
    public ManifestFile unmodifiable() {
        return this;
    }

    private void load(Manifest mf) {
        mf.getMainAttributes().forEach((k, v) -> this.put(k.toString(), (Object)v.toString()));
    }
}

