/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import org.apache.juneau.BeanSession;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;

public class HasQueryArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final String name;
    private final Type type;

    public static HasQueryArg create(ParameterInfo paramInfo) {
        if (AP.has(HasQuery.class, paramInfo, new AnnotationTraversal[0])) {
            return new HasQueryArg(paramInfo);
        }
        return null;
    }

    private static String getName(HasQuery x) {
        return StringUtils.firstNonEmpty((String[])new String[]{x.name(), x.value()});
    }

    private static boolean hasName(HasQuery x) {
        return StringUtils.isAnyNotBlank((CharSequence[])new CharSequence[]{x.name(), x.value()});
    }

    protected HasQueryArg(ParameterInfo pi) {
        this.name = AP.find(HasQuery.class, pi, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).filter(HasQueryArg::hasName).findFirst().map(HasQueryArg::getName).orElseThrow(() -> new ArgException(pi, "@HasQuery used without name or value", new Object[0]));
        this.type = pi.getParameterType().innerType();
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        BeanSession bs = req.getBeanSession();
        return bs.convertToType((Object)req.getQueryParams().contains(this.name), bs.getClassMeta(this.type, new Type[0]));
    }
}

