/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;

public class ParentPropertyAnnotation {
    public static final ParentProperty DEFAULT = ParentPropertyAnnotation.create().build();

    public static ParentProperty copy(ParentProperty a, VarResolverSession r) {
        return ParentPropertyAnnotation.create().on(r.resolve(a.on())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String ... on) {
        return ParentPropertyAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderMF {
        private String[] description = new String[0];

        protected Builder() {
            super(ParentProperty.class);
        }

        public ParentProperty build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedAnnotationObject
    implements ParentProperty {
        private final String[] description;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public ParentProperty[] value();
    }

    public static class Applier
    extends AnnotationApplier<ParentProperty, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(ParentProperty.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<ParentProperty> ai, BeanContext.Builder b) {
            ParentProperty a = ai.inner();
            if (CollectionUtils.isEmptyArray(a.on())) {
                return;
            }
            b.annotations(ParentPropertyAnnotation.copy(a, this.vr()));
        }
    }
}

