/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.CardinalityQRestriction;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.QualifiedRestrictionImpl;

public class CardinalityQRestrictionImpl
extends QualifiedRestrictionImpl
implements CardinalityQRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new CardinalityQRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + String.valueOf(n) + " to CardinalityQRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return CardinalityQRestrictionImpl.isCardinalityQRestriction(node, eg);
        }
    };

    public static boolean isCardinalityQRestriction(Node node, EnhGraph eg) {
        Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
        return profile != null && profile.isSupported(node, eg, CardinalityQRestriction.class);
    }

    @Override
    public boolean isValid() {
        return CardinalityQRestrictionImpl.isCardinalityQRestriction(this.asNode(), this.getGraph());
    }

    public CardinalityQRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setCardinalityQ(int cardinality) {
        this.setPropertyValue(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getCardinalityQ() {
        return this.objectAsInt(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q");
    }

    @Override
    public boolean hasCardinalityQ(int cardinality) {
        return this.hasPropertyValue(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeCardinalityQ(int cardinality) {
        this.removePropertyValue(this.getProfile().CARDINALITY_Q(), "CARDINALITY_Q", this.getModel().createTypedLiteral(cardinality));
    }
}

