/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.TimeWindowCompactionStrategy;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;

public interface CassandraMailQueueViewDataDefinition {
    public static final CassandraDataDefinition MODULE = CassandraDataDefinition.table((String)"enqueuedMailsV4").comment("store enqueued mails, if a mail is enqueued into a mail queue, it also being stored in this table, when a mail is dequeued from a mail queue, the record associated with that mail still available in this table and will not be deleted immediately regarding to the performance impacts, but after some scheduled tasks").options(options -> (CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.timeWindowCompactionStrategy().withCompactionWindow(1L, TimeWindowCompactionStrategy.CompactionWindowUnit.HOURS))).statement(statement -> types -> statement.withPartitionKey("queueName", DataTypes.TEXT).withPartitionKey("timeRangeStart", DataTypes.TIMESTAMP).withPartitionKey("bucketId", DataTypes.INT).withClusteringColumn("enqueueId", DataTypes.UUID).withColumn("enqueuedTime", DataTypes.TIMESTAMP).withColumn("name", DataTypes.TEXT).withColumn("state", DataTypes.TEXT).withColumn("headerBlobId", DataTypes.TEXT).withColumn("bodyBlobId", DataTypes.TEXT).withColumn("attributes", (DataType)DataTypes.frozenMapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.BLOB)).withColumn("errorMessage", DataTypes.TEXT).withColumn("sender", DataTypes.TEXT).withColumn("recipients", (DataType)DataTypes.frozenListOf((DataType)DataTypes.TEXT)).withColumn("remoteHost", DataTypes.TEXT).withColumn("remoteAddr", DataTypes.TEXT).withColumn("lastUpdated", DataTypes.TIMESTAMP).withColumn("perRecipientSpecificHeaders", (DataType)DataTypes.frozenListOf((DataType)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, DataTypes.TEXT, DataTypes.TEXT})))).table("browseStart").comment("this table allows to find the starting point of iteration from the table: enqueuedMailsV4 in order to make a browse operation through mail queues").options(options -> options).statement(statement -> types -> statement.withPartitionKey("queueName", DataTypes.TEXT).withColumn("browseStart", DataTypes.TIMESTAMP)).table("contentStart").comment("this table allows to find the starting point of content from the table: enqueuedMailsV4 in order to make a browse operation through mail queues. Strictly before browse start, it enables queue cleanup.").options(options -> options).statement(statement -> types -> statement.withPartitionKey("queueName", DataTypes.TEXT).withColumn("contentStart", DataTypes.TIMESTAMP)).table("deletedMailsV2").comment("this table stores the dequeued mails, while browsing mail from table: deletedMailsV2 we need to filter out mails have been dequeued by checking their existence in this table").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.timeWindowCompactionStrategy())).withBloomFilterFpChance(0.01)).statement(statement -> types -> statement.withPartitionKey("queueName", DataTypes.TEXT).withPartitionKey("enqueueId", DataTypes.UUID)).build();

    public static interface DeletedMailTable {
        public static final String TABLE_NAME = "deletedMailsV2";
        public static final String QUEUE_NAME = "queueName";
        public static final String ENQUEUE_ID = "enqueueId";
    }

    public static interface ContentStartTable {
        public static final String TABLE_NAME = "contentStart";
        public static final String QUEUE_NAME = "queueName";
        public static final String CONTENT_START = "contentStart";
    }

    public static interface BrowseStartTable {
        public static final String TABLE_NAME = "browseStart";
        public static final String QUEUE_NAME = "queueName";
        public static final String BROWSE_START = "browseStart";
    }

    public static interface EnqueuedMailsTable {
        public static final String TABLE_NAME = "enqueuedMailsV4";
        public static final String QUEUE_NAME = "queueName";
        public static final String TIME_RANGE_START = "timeRangeStart";
        public static final String BUCKET_ID = "bucketId";
        public static final String ENQUEUED_TIME = "enqueuedTime";
        public static final String ENQUEUE_ID = "enqueueId";
        public static final String NAME = "name";
        public static final String HEADER_BLOB_ID = "headerBlobId";
        public static final String BODY_BLOB_ID = "bodyBlobId";
        public static final String STATE = "state";
        public static final String SENDER = "sender";
        public static final String RECIPIENTS = "recipients";
        public static final String ATTRIBUTES = "attributes";
        public static final String ERROR_MESSAGE = "errorMessage";
        public static final String REMOTE_HOST = "remoteHost";
        public static final String REMOTE_ADDR = "remoteAddr";
        public static final String LAST_UPDATED = "lastUpdated";
        public static final String PER_RECIPIENT_SPECIFIC_HEADERS = "perRecipientSpecificHeaders";
    }

    public static interface HeaderEntry {
        public static final int USER_INDEX = 0;
        public static final int HEADER_NAME_INDEX = 1;
        public static final int HEADER_VALUE_INDEX = 2;
    }
}

