/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.forgerockds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.forgerockds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AffinityRequestControl
extends Control {
    @NotNull
    public static final String AFFINITY_REQUEST_OID = "1.3.6.1.4.1.36733.2.1.5.2";
    private static final long serialVersionUID = 7792760251213801179L;
    @NotNull
    private final ASN1OctetString affinityValue;

    public AffinityRequestControl(boolean isCritical) {
        this(isCritical, new ASN1OctetString(StaticUtils.randomBytes(5, true)));
    }

    public AffinityRequestControl(boolean isCritical, @NotNull String affinityValue) {
        this(isCritical, new ASN1OctetString(affinityValue));
    }

    public AffinityRequestControl(boolean isCritical, @NotNull byte[] affinityValue) {
        this(isCritical, new ASN1OctetString(affinityValue));
    }

    public AffinityRequestControl(boolean isCritical, @NotNull ASN1OctetString affinityValue) {
        super(AFFINITY_REQUEST_OID, isCritical, affinityValue);
        this.affinityValue = affinityValue;
    }

    public AffinityRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        this.affinityValue = control.getValue();
        if (this.affinityValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_AFFINITY_REQUEST_MISSING_VALUE.get());
        }
    }

    @NotNull
    public ASN1OctetString getAffinityValue() {
        return this.affinityValue;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_AFFINITY_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AffinityRequestControl(");
        byte[] affinityValueBytes = this.affinityValue.getValue();
        if (StaticUtils.isLikelyDisplayableUTF8String(affinityValueBytes)) {
            buffer.append("affinityValueString='");
            buffer.append(this.affinityValue.stringValue());
        } else {
            buffer.append("affinityValueBytes='");
            StaticUtils.toHex(affinityValueBytes, buffer);
        }
        buffer.append("')");
    }
}

