/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.vault.dto.query.QueryDTO;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.dto.query.QueryTranslator;
import org.apache.james.vault.search.Query;
import org.apache.james.webadmin.vault.routes.DeletedMessagesVaultRestoreTask;
import org.apache.james.webadmin.vault.routes.RestoreService;

public class DeletedMessagesVaultRestoreTaskDTO
implements TaskDTO {
    private final String type;
    private final String userToRestore;
    private final QueryDTO query;

    public static TaskDTOModule<DeletedMessagesVaultRestoreTask, DeletedMessagesVaultRestoreTaskDTO> module(Factory factory) {
        return (TaskDTOModule)DTOModule.forDomainObject(DeletedMessagesVaultRestoreTask.class).convertToDTO(DeletedMessagesVaultRestoreTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(factory::createDTO).typeName(DeletedMessagesVaultRestoreTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public DeletedMessagesVaultRestoreTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="userToRestore") String userToRestore, @JsonProperty(value="query") QueryDTO query) {
        this.type = type;
        this.userToRestore = userToRestore;
        this.query = query;
    }

    public String getUserToRestore() {
        return this.userToRestore;
    }

    public QueryDTO getQuery() {
        return this.query;
    }

    public String getType() {
        return this.type;
    }

    public static class Factory {
        private final RestoreService restoreService;
        private final QueryTranslator queryTranslator;

        @Inject
        public Factory(RestoreService restoreService, QueryTranslator queryTranslator) {
            this.restoreService = restoreService;
            this.queryTranslator = queryTranslator;
        }

        public DeletedMessagesVaultRestoreTask create(DeletedMessagesVaultRestoreTaskDTO dto) {
            Username usernameToRestore = Username.of((String)dto.userToRestore);
            Query query = this.queryTranslator.translate((QueryElement)dto.query);
            return new DeletedMessagesVaultRestoreTask(this.restoreService, usernameToRestore, query);
        }

        public DeletedMessagesVaultRestoreTaskDTO createDTO(DeletedMessagesVaultRestoreTask task, String type) {
            return new DeletedMessagesVaultRestoreTaskDTO(type, task.getUserToRestore().asString(), this.queryTranslator.toDTO(task.query));
        }
    }
}

