/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.replication;

import io.r2dbc.postgresql.replication.ReplicationType;
import io.r2dbc.postgresql.util.Assert;

public abstract class ReplicationSlotRequest {
    private final ReplicationType replicationType;
    private final String slotName;
    private final boolean temporary;

    ReplicationSlotRequest(ReplicationType replicationType, String slotName, boolean temporary) {
        this.replicationType = Assert.requireNonNull(replicationType, "replicationType must not be null");
        this.slotName = Assert.requireNotEmpty(slotName, "slotName must not be null");
        this.temporary = temporary;
    }

    public static LogicalSlotRequestBuilderStep1 logical() {
        return new DefaultLogicalSlotRequestBuilder();
    }

    public static PhysicalSlotRequestBuilderStep1 physical() {
        return new DefaultPhysicalSlotRequestBuilder();
    }

    public abstract String asSQL();

    public ReplicationType getReplicationType() {
        return this.replicationType;
    }

    String getSlotName() {
        return this.slotName;
    }

    boolean isTemporary() {
        return this.temporary;
    }

    public static interface WithOutputPlugin {
        public WithOutputPlugin outputPlugin(String var1);
    }

    public static interface WithSlotName {
        public WithSlotName slotName(String var1);
    }

    public static interface WithTemporary {
        public WithTemporary temporary();
    }

    public static interface PhysicalSlotRequestBuilder
    extends PhysicalSlotRequestBuilderStep1,
    WithTemporary {
        @Override
        public PhysicalSlotRequestBuilder slotName(String var1);

        @Override
        public PhysicalSlotRequestBuilder temporary();

        public ReplicationSlotRequest build();
    }

    public static interface PhysicalSlotRequestBuilderStep1
    extends WithSlotName {
        @Override
        public PhysicalSlotRequestBuilder slotName(String var1);
    }

    public static interface LogicalSlotRequestBuilder
    extends LogicalSlotRequestBuilderStep1,
    LogicalSlotRequestBuilderStep2,
    WithTemporary {
        @Override
        public LogicalSlotRequestBuilder slotName(String var1);

        @Override
        public LogicalSlotRequestBuilder temporary();

        public ReplicationSlotRequest build();
    }

    public static interface LogicalSlotRequestBuilderStep2
    extends WithOutputPlugin,
    WithSlotName {
        @Override
        public LogicalSlotRequestBuilder outputPlugin(String var1);
    }

    public static interface LogicalSlotRequestBuilderStep1
    extends WithSlotName {
        @Override
        public LogicalSlotRequestBuilderStep2 slotName(String var1);
    }

    static final class DefaultPhysicalSlotRequestBuilder
    implements PhysicalSlotRequestBuilder {
        private String slotName;
        private boolean temporary;

        DefaultPhysicalSlotRequestBuilder() {
        }

        @Override
        public DefaultPhysicalSlotRequestBuilder slotName(String slotName) {
            this.slotName = Assert.requireNotEmpty(slotName, "slotName must not be null and not empty");
            return this;
        }

        @Override
        public DefaultPhysicalSlotRequestBuilder temporary() {
            this.temporary = true;
            return this;
        }

        @Override
        public ReplicationSlotRequest build() {
            return new PhysicalReplicationSlotRequest(this.slotName, this.temporary);
        }
    }

    static final class DefaultLogicalSlotRequestBuilder
    implements LogicalSlotRequestBuilder {
        private String slotName;
        private String outputPlugin;
        private boolean temporary;

        DefaultLogicalSlotRequestBuilder() {
        }

        @Override
        public LogicalSlotRequestBuilder slotName(String slotName) {
            this.slotName = Assert.requireNotEmpty(slotName, "slotName must not be null and not empty");
            return this;
        }

        @Override
        public LogicalSlotRequestBuilder outputPlugin(String outputPlugin) {
            this.outputPlugin = Assert.requireNotEmpty(outputPlugin, "outputPlugin must not be null and not empty");
            return this;
        }

        @Override
        public LogicalSlotRequestBuilder temporary() {
            this.temporary = true;
            return this;
        }

        @Override
        public ReplicationSlotRequest build() {
            return new LogicalReplicationSlotRequest(this.slotName, this.temporary, this.outputPlugin);
        }
    }

    static class PhysicalReplicationSlotRequest
    extends ReplicationSlotRequest {
        public PhysicalReplicationSlotRequest(String slotName, boolean temporaryOption) {
            super(ReplicationType.PHYSICAL, slotName, temporaryOption);
        }

        @Override
        public String asSQL() {
            return String.format("CREATE_REPLICATION_SLOT %s %s PHYSICAL", this.getSlotName(), this.isTemporary() ? "TEMPORARY" : "");
        }

        public String toString() {
            return "PhysicalReplicationSlotRequest{slotName='" + this.getSlotName() + '\'' + ", temporaryOption=" + this.isTemporary() + '}';
        }
    }

    static class LogicalReplicationSlotRequest
    extends ReplicationSlotRequest {
        private final String outputPlugin;

        public LogicalReplicationSlotRequest(String slotName, boolean temporaryOption, String outputPlugin) {
            super(ReplicationType.LOGICAL, slotName, temporaryOption);
            this.outputPlugin = outputPlugin;
        }

        @Override
        public String asSQL() {
            return String.format("CREATE_REPLICATION_SLOT %s %s LOGICAL %s", this.getSlotName(), this.isTemporary() ? "TEMPORARY" : "", this.outputPlugin);
        }

        public String toString() {
            return "LogicalReplicationSlotRequest{slotName='" + this.getSlotName() + '\'' + ", outputPlugin='" + this.outputPlugin + '\'' + ", temporaryOption=" + this.isTemporary() + '}';
        }
    }
}

