/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.Utils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableModeAccumulator
implements TableAccumulator {
    private final int MAP_SIZE_THRESHOLD = IoTDBDescriptor.getInstance().getConfig().getModeMapSizeThreshold();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableModeAccumulator.class);
    private final TSDataType seriesDataType;
    private Map<Boolean, Long> booleanCountMap;
    private Map<Integer, Long> intCountMap;
    private Map<Float, Long> floatCountMap;
    private Map<Long, Long> longCountMap;
    private Map<Double, Long> doubleCountMap;
    private Map<Binary, Long> binaryCountMap;
    private long nullCount;

    public TableModeAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        switch (seriesDataType) {
            case BOOLEAN: {
                this.booleanCountMap = new HashMap<Boolean, Long>();
                break;
            }
            case INT32: 
            case DATE: {
                this.intCountMap = new HashMap<Integer, Long>();
                break;
            }
            case FLOAT: {
                this.floatCountMap = new HashMap<Float, Long>();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longCountMap = new HashMap<Long, Long>();
                break;
            }
            case DOUBLE: {
                this.doubleCountMap = new HashMap<Double, Long>();
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.binaryCountMap = new HashMap<Binary, Long>();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported data type : %s", seriesDataType));
            }
        }
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new TableModeAccumulator(this.seriesDataType);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        switch (this.seriesDataType) {
            case BOOLEAN: {
                this.addBooleanInput(arguments[0], mask);
                break;
            }
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0], mask);
                break;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], mask);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0], mask);
                break;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], mask);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0], mask);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported data type : %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void removeInput(Column[] arguments) {
        switch (this.seriesDataType) {
            case BOOLEAN: {
                this.removeBooleanInput(arguments[0]);
                break;
            }
            case INT32: 
            case DATE: {
                this.removeIntInput(arguments[0]);
                break;
            }
            case FLOAT: {
                this.removeFloatInput(arguments[0]);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.removeLongInput(arguments[0]);
                break;
            }
            case DOUBLE: {
                this.removeDoubleInput(arguments[0]);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.removeBinaryInput(arguments[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported data type : %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of Mode should be BinaryColumn");
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            this.deserializeAndMergeCountMap(bytes);
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output should be BinaryColumn");
        columnBuilder.writeBinary(new Binary(this.serializeCountMap()));
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        switch (this.seriesDataType) {
            case BOOLEAN: {
                if (this.booleanCountMap.isEmpty()) {
                    columnBuilder.appendNull();
                    break;
                }
                Map.Entry maxEntry = this.booleanCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).get();
                if ((Long)maxEntry.getValue() < this.nullCount) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeBoolean(((Boolean)maxEntry.getKey()).booleanValue());
                break;
            }
            case INT32: 
            case DATE: {
                if (this.intCountMap.isEmpty()) {
                    columnBuilder.appendNull();
                    break;
                }
                Map.Entry maxEntry = this.intCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).get();
                if ((Long)maxEntry.getValue() < this.nullCount) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeInt(((Integer)maxEntry.getKey()).intValue());
                break;
            }
            case FLOAT: {
                if (this.floatCountMap.isEmpty()) {
                    columnBuilder.appendNull();
                    break;
                }
                Map.Entry maxEntry = this.floatCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).get();
                if ((Long)maxEntry.getValue() < this.nullCount) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeFloat(((Float)maxEntry.getKey()).floatValue());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                if (this.longCountMap.isEmpty()) {
                    columnBuilder.appendNull();
                    break;
                }
                Map.Entry maxEntry = this.longCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).get();
                if ((Long)maxEntry.getValue() < this.nullCount) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeLong(((Long)maxEntry.getKey()).longValue());
                break;
            }
            case DOUBLE: {
                if (this.doubleCountMap.isEmpty()) {
                    columnBuilder.appendNull();
                    break;
                }
                Map.Entry maxEntry = this.doubleCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).get();
                if ((Long)maxEntry.getValue() < this.nullCount) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(((Double)maxEntry.getKey()).doubleValue());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                if (this.binaryCountMap.isEmpty()) {
                    columnBuilder.appendNull();
                    break;
                }
                Map.Entry maxEntry = this.binaryCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).get();
                if ((Long)maxEntry.getValue() < this.nullCount) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeBinary((Binary)maxEntry.getKey());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported data type : %s", this.seriesDataType));
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void reset() {
        if (this.booleanCountMap != null) {
            this.booleanCountMap.clear();
        }
        if (this.intCountMap != null) {
            this.intCountMap.clear();
        }
        if (this.floatCountMap != null) {
            this.floatCountMap.clear();
        }
        if (this.longCountMap != null) {
            this.longCountMap.clear();
        }
        if (this.doubleCountMap != null) {
            this.doubleCountMap.clear();
        }
        if (this.binaryCountMap != null) {
            this.binaryCountMap.clear();
        }
        this.nullCount = 0L;
    }

    @Override
    public boolean removable() {
        return true;
    }

    private byte[] serializeCountMap() {
        byte[] bytes;
        int offset = 1 + (this.nullCount == 0L ? 0 : 8);
        switch (this.seriesDataType) {
            case BOOLEAN: {
                bytes = new byte[offset + 4 + 9 * this.booleanCountMap.size()];
                BytesUtils.boolToBytes((this.nullCount != 0L ? 1 : 0) != 0, (byte[])bytes, (int)0);
                if (this.nullCount != 0L) {
                    BytesUtils.longToBytes((long)this.nullCount, (byte[])bytes, (int)1);
                }
                BytesUtils.intToBytes((int)this.booleanCountMap.size(), (byte[])bytes, (int)offset);
                offset += 4;
                for (Map.Entry<Boolean, Long> entry : this.booleanCountMap.entrySet()) {
                    BytesUtils.boolToBytes((boolean)entry.getKey(), (byte[])bytes, (int)offset);
                    BytesUtils.longToBytes((long)entry.getValue(), (byte[])bytes, (int)(++offset));
                    offset += 8;
                }
                break;
            }
            case INT32: 
            case DATE: {
                bytes = new byte[offset + 4 + 12 * this.intCountMap.size()];
                BytesUtils.boolToBytes((this.nullCount != 0L ? 1 : 0) != 0, (byte[])bytes, (int)0);
                if (this.nullCount != 0L) {
                    BytesUtils.longToBytes((long)this.nullCount, (byte[])bytes, (int)1);
                }
                BytesUtils.intToBytes((int)this.intCountMap.size(), (byte[])bytes, (int)offset);
                offset += 4;
                for (Map.Entry<Integer, Long> entry : this.intCountMap.entrySet()) {
                    BytesUtils.intToBytes((int)entry.getKey(), (byte[])bytes, (int)offset);
                    BytesUtils.longToBytes((long)entry.getValue(), (byte[])bytes, (int)(offset += 4));
                    offset += 8;
                }
                break;
            }
            case FLOAT: {
                bytes = new byte[offset + 4 + 12 * this.floatCountMap.size()];
                BytesUtils.boolToBytes((this.nullCount != 0L ? 1 : 0) != 0, (byte[])bytes, (int)0);
                if (this.nullCount != 0L) {
                    BytesUtils.longToBytes((long)this.nullCount, (byte[])bytes, (int)1);
                }
                BytesUtils.intToBytes((int)this.floatCountMap.size(), (byte[])bytes, (int)offset);
                offset += 4;
                for (Map.Entry<Float, Long> entry : this.floatCountMap.entrySet()) {
                    BytesUtils.floatToBytes((float)entry.getKey().floatValue(), (byte[])bytes, (int)offset);
                    BytesUtils.longToBytes((long)entry.getValue(), (byte[])bytes, (int)(offset += 4));
                    offset += 8;
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                bytes = new byte[offset + 4 + 16 * this.longCountMap.size()];
                BytesUtils.boolToBytes((this.nullCount != 0L ? 1 : 0) != 0, (byte[])bytes, (int)0);
                if (this.nullCount != 0L) {
                    BytesUtils.longToBytes((long)this.nullCount, (byte[])bytes, (int)1);
                }
                BytesUtils.intToBytes((int)this.longCountMap.size(), (byte[])bytes, (int)offset);
                offset += 4;
                for (Map.Entry<Long, Long> entry : this.longCountMap.entrySet()) {
                    BytesUtils.longToBytes((long)entry.getKey(), (byte[])bytes, (int)offset);
                    BytesUtils.longToBytes((long)entry.getValue(), (byte[])bytes, (int)(offset += 8));
                    offset += 8;
                }
                break;
            }
            case DOUBLE: {
                bytes = new byte[offset + 4 + 16 * this.doubleCountMap.size()];
                BytesUtils.boolToBytes((this.nullCount != 0L ? 1 : 0) != 0, (byte[])bytes, (int)0);
                if (this.nullCount != 0L) {
                    BytesUtils.longToBytes((long)this.nullCount, (byte[])bytes, (int)1);
                }
                BytesUtils.intToBytes((int)this.doubleCountMap.size(), (byte[])bytes, (int)offset);
                offset += 4;
                for (Map.Entry<Double, Long> entry : this.doubleCountMap.entrySet()) {
                    BytesUtils.doubleToBytes((double)entry.getKey(), (byte[])bytes, (int)offset);
                    BytesUtils.longToBytes((long)entry.getValue(), (byte[])bytes, (int)(offset += 8));
                    offset += 8;
                }
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                bytes = new byte[offset + 4 + 12 * this.binaryCountMap.size() + this.binaryCountMap.keySet().stream().mapToInt(key -> key.getValues().length).sum()];
                BytesUtils.boolToBytes((this.nullCount != 0L ? 1 : 0) != 0, (byte[])bytes, (int)0);
                if (this.nullCount != 0L) {
                    BytesUtils.longToBytes((long)this.nullCount, (byte[])bytes, (int)1);
                }
                BytesUtils.intToBytes((int)this.binaryCountMap.size(), (byte[])bytes, (int)offset);
                offset += 4;
                for (Map.Entry<Binary, Long> entry : this.binaryCountMap.entrySet()) {
                    Binary binary = entry.getKey();
                    Utils.serializeBinaryValue(binary, bytes, offset);
                    BytesUtils.longToBytes((long)entry.getValue(), (byte[])bytes, (int)(offset += 4 + binary.getLength()));
                    offset += 8;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported data type : %s", this.seriesDataType));
            }
        }
        return bytes;
    }

    private void deserializeAndMergeCountMap(byte[] bytes) {
        int offset = 0;
        if (BytesUtils.bytesToBool((byte[])bytes, (int)0)) {
            this.nullCount += BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)1);
            offset += 8;
        }
        int size = BytesUtils.bytesToInt((byte[])bytes, (int)(++offset));
        offset += 4;
        switch (this.seriesDataType) {
            case BOOLEAN: {
                for (int i = 0; i < size; ++i) {
                    boolean key = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                    long count = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)(++offset));
                    offset += 8;
                    this.booleanCountMap.compute(key, (k, v) -> v == null ? count : v + count);
                }
                break;
            }
            case INT32: 
            case DATE: {
                for (int i = 0; i < size; ++i) {
                    int key = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    long count = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)(offset += 4));
                    offset += 8;
                    this.intCountMap.compute(key, (k, v) -> v == null ? count : v + count);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < size; ++i) {
                    float key = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                    long count = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)(offset += 4));
                    offset += 8;
                    this.floatCountMap.compute(Float.valueOf(key), (k, v) -> v == null ? count : v + count);
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                for (int i = 0; i < size; ++i) {
                    long key = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                    long count = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)(offset += 8));
                    offset += 8;
                    this.longCountMap.compute(key, (k, v) -> v == null ? count : v + count);
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < size; ++i) {
                    double key = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                    long count = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)(offset += 8));
                    offset += 8;
                    this.doubleCountMap.compute(key, (k, v) -> v == null ? count : v + count);
                }
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                for (int i = 0; i < size; ++i) {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    Binary binaryVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                    long count = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)(offset += length));
                    offset += 8;
                    this.binaryCountMap.compute(binaryVal, (k, v) -> v == null ? count : v + count);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported data type : %s", this.seriesDataType));
            }
        }
    }

    private void addBooleanInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (!column.isNull(i)) {
                    this.booleanCountMap.compute(column.getBoolean(i), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.booleanCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (!column.isNull(position)) {
                    this.booleanCountMap.compute(column.getBoolean(position), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.booleanCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        }
    }

    private void addIntInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (!column.isNull(i)) {
                    this.intCountMap.compute(column.getInt(i), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.intCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (!column.isNull(position)) {
                    this.intCountMap.compute(column.getInt(position), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.intCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        }
    }

    private void addFloatInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (!column.isNull(i)) {
                    this.floatCountMap.compute(Float.valueOf(column.getFloat(i)), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.floatCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (!column.isNull(position)) {
                    this.floatCountMap.compute(Float.valueOf(column.getFloat(position)), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.floatCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        }
    }

    private void addLongInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (!column.isNull(i)) {
                    this.longCountMap.compute(column.getLong(i), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.longCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (!column.isNull(position)) {
                    this.longCountMap.compute(column.getLong(position), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.longCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        }
    }

    private void addDoubleInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (!column.isNull(i)) {
                    this.doubleCountMap.compute(column.getDouble(i), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.doubleCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (!column.isNull(position)) {
                    this.doubleCountMap.compute(column.getDouble(position), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.doubleCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        }
    }

    private void addBinaryInput(Column column, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (!column.isNull(i)) {
                    this.binaryCountMap.compute(column.getBinary(i), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.binaryCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (!column.isNull(position)) {
                    this.binaryCountMap.compute(column.getBinary(position), (k, v) -> v == null ? 1L : v + 1L);
                    this.checkMapSize(this.binaryCountMap.size());
                    continue;
                }
                ++this.nullCount;
            }
        }
    }

    private void removeBooleanInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (!column.isNull(i)) {
                boolean key = column.getBoolean(i);
                this.booleanCountMap.compute(key, (k, count) -> count - 1L);
                continue;
            }
            --this.nullCount;
        }
    }

    private void removeIntInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (!column.isNull(i)) {
                int key = column.getInt(i);
                this.intCountMap.compute(key, (k, count) -> count - 1L);
                continue;
            }
            --this.nullCount;
        }
    }

    private void removeFloatInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (!column.isNull(i)) {
                float key = column.getFloat(i);
                this.floatCountMap.compute(Float.valueOf(key), (k, count) -> count - 1L);
                continue;
            }
            --this.nullCount;
        }
    }

    private void removeLongInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (!column.isNull(i)) {
                long key = column.getLong(i);
                this.longCountMap.compute(key, (k, count) -> count - 1L);
                continue;
            }
            --this.nullCount;
        }
    }

    private void removeDoubleInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (!column.isNull(i)) {
                double key = column.getDouble(i);
                this.doubleCountMap.compute(key, (k, count) -> count - 1L);
                continue;
            }
            --this.nullCount;
        }
    }

    private void removeBinaryInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (!column.isNull(i)) {
                Binary key = column.getBinary(i);
                this.binaryCountMap.compute(key, (k, count) -> count - 1L);
                continue;
            }
            --this.nullCount;
        }
    }

    private void checkMapSize(int size) {
        if (size > this.MAP_SIZE_THRESHOLD) {
            throw new RuntimeException(String.format("distinct values has exceeded the threshold %s when calculate Mode", this.MAP_SIZE_THRESHOLD));
        }
    }
}

