/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactionAlignedPageLazyLoadPointReader;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;

public class CompactionAlignedChunkReader {
    private final List<ChunkHeader> valueChunkHeaderList = new ArrayList<ChunkHeader>();
    private final IUnCompressor timeUnCompressor;
    private final EncryptParameter encryptParam;
    private final boolean ignoreAllNullRows;
    private final Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    private final List<TimeRange> timeDeleteIntervalList;
    private final List<List<TimeRange>> valueDeleteIntervalList;

    public CompactionAlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, boolean ignoreAllNullRows) {
        ChunkHeader timeChunkHeader = timeChunk.getHeader();
        this.timeUnCompressor = IUnCompressor.getUnCompressor((CompressionType)timeChunkHeader.getCompressionType());
        this.encryptParam = timeChunk.getEncryptParam();
        this.timeDeleteIntervalList = timeChunk.getDeleteIntervalList();
        this.valueDeleteIntervalList = new ArrayList<List<TimeRange>>(valueChunkList.size());
        valueChunkList.forEach(chunk -> {
            this.valueChunkHeaderList.add(chunk == null ? null : chunk.getHeader());
            this.valueDeleteIntervalList.add(chunk == null ? null : chunk.getDeleteIntervalList());
        });
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    public IPointReader getPagePointReader(PageHeader timePageHeader, List<PageHeader> valuePageHeaders, ByteBuffer compressedTimePageData, List<ByteBuffer> compressedValuePageDatas) throws IOException {
        return this.getPontReader(timePageHeader, valuePageHeaders, compressedTimePageData, compressedValuePageDatas, this.ignoreAllNullRows);
    }

    public IPointReader getBatchedPagePointReader(PageHeader timePageHeader, List<PageHeader> valuePageHeaders, ByteBuffer compressedTimePageData, List<ByteBuffer> compressedValuePageDatas) throws IOException {
        return this.getPontReader(timePageHeader, valuePageHeaders, compressedTimePageData, compressedValuePageDatas, false);
    }

    private IPointReader getPontReader(PageHeader timePageHeader, List<PageHeader> valuePageHeaders, ByteBuffer compressedTimePageData, List<ByteBuffer> compressedValuePageDatas, boolean ignoreAllNullRows) throws IOException {
        IDecryptor decryptor = IDecryptor.getDecryptor((EncryptParameter)this.encryptParam);
        ByteBuffer uncompressedTimePageData = ChunkReader.decryptAndUncompressPageData((PageHeader)timePageHeader, (IUnCompressor)this.timeUnCompressor, (ByteBuffer)compressedTimePageData, (IDecryptor)decryptor);
        TimePageReader timePageReader = new TimePageReader(timePageHeader, uncompressedTimePageData, this.timeDecoder);
        timePageReader.setDeleteIntervalList(this.timeDeleteIntervalList);
        ArrayList<ValuePageReader> valuePageReaders = new ArrayList<ValuePageReader>(valuePageHeaders.size());
        for (int i = 0; i < valuePageHeaders.size(); ++i) {
            if (valuePageHeaders.get(i) == null) {
                valuePageReaders.add(null);
                continue;
            }
            ChunkHeader valueChunkHeader = this.valueChunkHeaderList.get(i);
            ByteBuffer uncompressedPageData = ChunkReader.decryptAndUncompressPageData((PageHeader)valuePageHeaders.get(i), (IUnCompressor)IUnCompressor.getUnCompressor((CompressionType)valueChunkHeader.getCompressionType()), (ByteBuffer)compressedValuePageDatas.get(i), (IDecryptor)decryptor);
            TSDataType valueType = valueChunkHeader.getDataType();
            ValuePageReader valuePageReader = new ValuePageReader(valuePageHeaders.get(i), uncompressedPageData, valueType, Decoder.getDecoderByType((TSEncoding)valueChunkHeader.getEncodingType(), (TSDataType)valueType));
            valuePageReader.setDeleteIntervalList(this.valueDeleteIntervalList.get(i));
            valuePageReaders.add(valuePageReader);
        }
        return new CompactionAlignedPageLazyLoadPointReader(timePageReader, valuePageReaders, ignoreAllNullRows);
    }
}

