/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.leader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.AbstractLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;

public class HashLeaderBalancer
extends AbstractLeaderBalancer {
    @Override
    public Map<TConsensusGroupId, Integer> generateOptimalLeaderDistribution(Map<String, List<TConsensusGroupId>> databaseRegionGroupMap, Map<TConsensusGroupId, Set<Integer>> regionLocationMap, Map<TConsensusGroupId, Integer> regionLeaderMap, Map<Integer, NodeStatistics> dataNodeStatisticsMap, Map<TConsensusGroupId, Map<Integer, RegionStatistics>> regionStatisticsMap) {
        HashMap<TConsensusGroupId, Integer> result = new HashMap<TConsensusGroupId, Integer>();
        regionLocationMap.forEach((gid, nodeSet) -> {
            ArrayList nodeList = new ArrayList(nodeSet);
            nodeList.sort(null);
            int startNodeIndex = Math.abs(gid.hashCode()) % nodeList.size();
            int finalNodeId = (Integer)nodeList.get(startNodeIndex);
            for (int i = 0; i < nodeList.size(); ++i) {
                int currentNodeIndex = (startNodeIndex + i) % nodeList.size();
                int currentNodeId = (Integer)nodeList.get(currentNodeIndex);
                NodeStatistics nodeStatistics = (NodeStatistics)dataNodeStatisticsMap.get(currentNodeId);
                if (nodeStatistics == null || nodeStatistics.getStatus() != NodeStatus.Running) continue;
                finalNodeId = currentNodeId;
                break;
            }
            result.put((TConsensusGroupId)gid, finalNodeId);
        });
        return result;
    }
}

