/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.aws;

import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.storage.InMemoryStorageIntegration;
import org.apache.polaris.core.storage.StorageAccessConfig;
import org.apache.polaris.core.storage.StorageAccessProperty;
import org.apache.polaris.core.storage.StorageUtil;
import org.apache.polaris.core.storage.aws.AwsStorageConfigurationInfo;
import org.apache.polaris.core.storage.aws.StsClientProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.policybuilder.iam.IamEffect;
import software.amazon.awssdk.policybuilder.iam.IamPolicy;
import software.amazon.awssdk.policybuilder.iam.IamResource;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;

public class AwsCredentialsStorageIntegration
extends InMemoryStorageIntegration<AwsStorageConfigurationInfo> {
    private final StsClientProvider stsClientProvider;
    private final Optional<AwsCredentialsProvider> credentialsProvider;

    public AwsCredentialsStorageIntegration(AwsStorageConfigurationInfo config, StsClient fixedClient) {
        this(config, (StsClientProvider.StsDestination destination) -> fixedClient);
    }

    public AwsCredentialsStorageIntegration(AwsStorageConfigurationInfo config, StsClientProvider stsClientProvider) {
        this(config, stsClientProvider, Optional.empty());
    }

    public AwsCredentialsStorageIntegration(AwsStorageConfigurationInfo config, StsClientProvider stsClientProvider, Optional<AwsCredentialsProvider> credentialsProvider) {
        super(config, AwsCredentialsStorageIntegration.class.getName());
        this.stsClientProvider = stsClientProvider;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public StorageAccessConfig getSubscopedCreds(@Nonnull RealmConfig realmConfig, boolean allowListOperation, @Nonnull Set<String> allowedReadLocations, @Nonnull Set<String> allowedWriteLocations, Optional<String> refreshCredentialsEndpoint) {
        URI internalEndpointUri;
        int storageCredentialDurationSeconds = realmConfig.getConfig(FeatureConfiguration.STORAGE_CREDENTIAL_DURATION_SECONDS);
        AwsStorageConfigurationInfo storageConfig = (AwsStorageConfigurationInfo)this.config();
        String region = storageConfig.getRegion();
        StorageAccessConfig.Builder accessConfig = StorageAccessConfig.builder();
        if (this.shouldUseSts(storageConfig)) {
            AssumeRoleRequest.Builder request = AssumeRoleRequest.builder().externalId(storageConfig.getExternalId()).roleArn(storageConfig.getRoleARN()).roleSessionName("PolarisAwsCredentialsStorageIntegration").policy(this.policyString(storageConfig.getAwsPartition(), allowListOperation, allowedReadLocations, allowedWriteLocations).toJson()).durationSeconds(Integer.valueOf(storageCredentialDurationSeconds));
            this.credentialsProvider.ifPresent(cp -> request.overrideConfiguration(b -> b.credentialsProvider(cp)));
            StsClient stsClient = this.stsClientProvider.stsClient(StsClientProvider.StsDestination.of(storageConfig.getStsEndpointUri(), region));
            AssumeRoleResponse response = stsClient.assumeRole((AssumeRoleRequest)request.build());
            accessConfig.put(StorageAccessProperty.AWS_KEY_ID, response.credentials().accessKeyId());
            accessConfig.put(StorageAccessProperty.AWS_SECRET_KEY, response.credentials().secretAccessKey());
            accessConfig.put(StorageAccessProperty.AWS_TOKEN, response.credentials().sessionToken());
            Optional.ofNullable(response.credentials().expiration()).ifPresent(i -> {
                accessConfig.put(StorageAccessProperty.EXPIRATION_TIME, String.valueOf(i.toEpochMilli()));
                accessConfig.put(StorageAccessProperty.AWS_SESSION_TOKEN_EXPIRES_AT_MS, String.valueOf(i.toEpochMilli()));
            });
        }
        if (region != null) {
            accessConfig.put(StorageAccessProperty.CLIENT_REGION, region);
        }
        refreshCredentialsEndpoint.ifPresent(endpoint -> accessConfig.put(StorageAccessProperty.AWS_REFRESH_CREDENTIALS_ENDPOINT, (String)endpoint));
        URI endpointUri = storageConfig.getEndpointUri();
        if (endpointUri != null) {
            accessConfig.put(StorageAccessProperty.AWS_ENDPOINT, endpointUri.toString());
        }
        if ((internalEndpointUri = storageConfig.getInternalEndpointUri()) != null) {
            accessConfig.putInternalProperty(StorageAccessProperty.AWS_ENDPOINT.getPropertyName(), internalEndpointUri.toString());
        }
        if (Boolean.TRUE.equals(storageConfig.getPathStyleAccess())) {
            accessConfig.put(StorageAccessProperty.AWS_PATH_STYLE_ACCESS, Boolean.TRUE.toString());
        }
        if ("aws-us-gov".equals(storageConfig.getAwsPartition()) && region == null) {
            throw new IllegalArgumentException(String.format("AWS region must be set when using partition %s", storageConfig.getAwsPartition()));
        }
        return accessConfig.build();
    }

    private boolean shouldUseSts(AwsStorageConfigurationInfo storageConfig) {
        return !Boolean.TRUE.equals(storageConfig.getStsUnavailable());
    }

    private IamPolicy policyString(String awsPartition, boolean allowList, Set<String> readLocations, Set<String> writeLocations) {
        IamPolicy.Builder policyBuilder = IamPolicy.builder();
        IamStatement.Builder allowGetObjectStatementBuilder = IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:GetObject").addAction("s3:GetObjectVersion");
        HashMap bucketListStatementBuilder = new HashMap();
        HashMap bucketGetLocationStatementBuilder = new HashMap();
        String arnPrefix = AwsCredentialsStorageIntegration.arnPrefixForPartition(awsPartition);
        Stream.concat(readLocations.stream(), writeLocations.stream()).distinct().forEach(location -> {
            URI uri = URI.create(location);
            allowGetObjectStatementBuilder.addResource(IamResource.create((String)(arnPrefix + StorageUtil.concatFilePrefixes(AwsCredentialsStorageIntegration.parseS3Path(uri), "*", "/"))));
            String bucket = arnPrefix + StorageUtil.getBucket(uri);
            if (allowList) {
                bucketListStatementBuilder.computeIfAbsent(bucket, key -> IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:ListBucket").addResource(key)).addCondition(IamConditionOperator.STRING_LIKE, "s3:prefix", StorageUtil.concatFilePrefixes(AwsCredentialsStorageIntegration.trimLeadingSlash(uri.getPath()), "*", "/"));
            }
            bucketGetLocationStatementBuilder.computeIfAbsent(bucket, key -> IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:GetBucketLocation").addResource(key));
        });
        if (!writeLocations.isEmpty()) {
            IamStatement.Builder allowPutObjectStatementBuilder = IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:PutObject").addAction("s3:DeleteObject");
            writeLocations.forEach(location -> {
                URI uri = URI.create(location);
                allowPutObjectStatementBuilder.addResource(IamResource.create((String)(arnPrefix + StorageUtil.concatFilePrefixes(AwsCredentialsStorageIntegration.parseS3Path(uri), "*", "/"))));
            });
            policyBuilder.addStatement((IamStatement)allowPutObjectStatementBuilder.build());
        }
        if (!bucketListStatementBuilder.isEmpty()) {
            bucketListStatementBuilder.values().forEach(statementBuilder -> policyBuilder.addStatement((IamStatement)statementBuilder.build()));
        } else if (allowList) {
            policyBuilder.addStatement((IamStatement)IamStatement.builder().effect(IamEffect.ALLOW).addAction("s3:ListBucket").build());
        }
        bucketGetLocationStatementBuilder.values().forEach(statementBuilder -> policyBuilder.addStatement((IamStatement)statementBuilder.build()));
        return (IamPolicy)policyBuilder.addStatement((IamStatement)allowGetObjectStatementBuilder.build()).build();
    }

    private static String arnPrefixForPartition(String awsPartition) {
        return String.format("arn:%s:s3:::", awsPartition != null ? awsPartition : "aws");
    }

    @Nonnull
    private static String parseS3Path(URI uri) {
        String bucket = StorageUtil.getBucket(uri);
        String path = AwsCredentialsStorageIntegration.trimLeadingSlash(uri.getPath());
        return String.join((CharSequence)"/", bucket, path);
    }

    @Nonnull
    private static String trimLeadingSlash(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

