/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.Objects;
import org.apache.polaris.core.admin.model.Principal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreatePrincipalRequest {
    @Valid
    private final Principal principal;
    private final Boolean credentialRotationRequired;

    @ApiModelProperty(value="")
    @JsonProperty(value="principal")
    public Principal getPrincipal() {
        return this.principal;
    }

    @ApiModelProperty(value="If true, the initial credentials can only be used to call rotateCredentials")
    @JsonProperty(value="credentialRotationRequired")
    public Boolean getCredentialRotationRequired() {
        return this.credentialRotationRequired;
    }

    @JsonCreator
    public CreatePrincipalRequest(@JsonProperty(value="principal") Principal principal, @JsonProperty(value="credentialRotationRequired") Boolean credentialRotationRequired) {
        this.principal = principal;
        this.credentialRotationRequired = credentialRotationRequired;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePrincipalRequest createPrincipalRequest = (CreatePrincipalRequest)o;
        return Objects.equals(this.principal, createPrincipalRequest.principal) && Objects.equals(this.credentialRotationRequired, createPrincipalRequest.credentialRotationRequired);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.credentialRotationRequired);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePrincipalRequest {\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    credentialRotationRequired: ").append(this.toIndentedString(this.credentialRotationRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private Principal principal;
        private Boolean credentialRotationRequired;

        private Builder() {
        }

        public Builder setPrincipal(Principal principal) {
            this.principal = principal;
            return this;
        }

        public Builder setCredentialRotationRequired(Boolean credentialRotationRequired) {
            this.credentialRotationRequired = credentialRotationRequired;
            return this;
        }

        public CreatePrincipalRequest build() {
            CreatePrincipalRequest inst = new CreatePrincipalRequest(this.principal, this.credentialRotationRequired);
            return inst;
        }
    }
}

