/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.util.Map;

public class PolarisEvent {
    public static final String EMPTY_MAP_STRING = "{}";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String catalogId;
    private final String id;
    @Nullable
    private final String requestId;
    private final String eventType;
    private final long timestampMs;
    @Nullable
    private final String principalName;
    private final ResourceType resourceType;
    private final String resourceIdentifier;
    private String additionalProperties;

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getRequestId() {
        return this.requestId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getTimestampMs() {
        return this.timestampMs;
    }

    @Nullable
    public String getPrincipalName() {
        return this.principalName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public String getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : EMPTY_MAP_STRING;
    }

    public PolarisEvent(String catalogId, String id, @Nullable String requestId, String eventType, long timestampMs, @Nullable String principalName, ResourceType resourceType, String resourceIdentifier) {
        this.catalogId = catalogId;
        this.id = id;
        this.requestId = requestId;
        this.eventType = eventType;
        this.timestampMs = timestampMs;
        this.principalName = principalName;
        this.resourceType = resourceType;
        this.resourceIdentifier = resourceIdentifier;
    }

    @JsonIgnore
    public void setAdditionalProperties(Map<String, String> properties) {
        try {
            this.additionalProperties = properties == null ? null : MAPPER.writeValueAsString(properties);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(String.format("Failed to serialize json. properties %s", properties), ex);
        }
    }

    public void setAdditionalProperties(String additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public static enum ResourceType {
        CATALOG,
        NAMESPACE,
        TABLE,
        VIEW;

    }
}

