/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iceberg.metrics.CommitMetrics;
import org.apache.iceberg.metrics.CounterResult;
import org.apache.iceberg.metrics.ImmutableCommitMetricsResult;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.TimerResult;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.immutables.value.Value;

@Value.Immutable
public interface CommitMetricsResult {
    public static final String ADDED_DATA_FILES = "added-data-files";
    public static final String REMOVED_DATA_FILES = "removed-data-files";
    public static final String TOTAL_DATA_FILES = "total-data-files";
    public static final String ADDED_DELETE_FILES = "added-delete-files";
    public static final String ADDED_EQ_DELETE_FILES = "added-equality-delete-files";
    public static final String ADDED_POS_DELETE_FILES = "added-positional-delete-files";
    public static final String ADDED_DVS = "added-dvs";
    public static final String REMOVED_POS_DELETE_FILES = "removed-positional-delete-files";
    public static final String REMOVED_DVS = "removed-dvs";
    public static final String REMOVED_EQ_DELETE_FILES = "removed-equality-delete-files";
    public static final String REMOVED_DELETE_FILES = "removed-delete-files";
    public static final String TOTAL_DELETE_FILES = "total-delete-files";
    public static final String ADDED_RECORDS = "added-records";
    public static final String REMOVED_RECORDS = "removed-records";
    public static final String TOTAL_RECORDS = "total-records";
    public static final String ADDED_FILE_SIZE_BYTES = "added-files-size-bytes";
    public static final String REMOVED_FILE_SIZE_BYTES = "removed-files-size-bytes";
    public static final String TOTAL_FILE_SIZE_BYTES = "total-files-size-bytes";
    public static final String ADDED_POS_DELETES = "added-positional-deletes";
    public static final String REMOVED_POS_DELETES = "removed-positional-deletes";
    public static final String TOTAL_POS_DELETES = "total-positional-deletes";
    public static final String ADDED_EQ_DELETES = "added-equality-deletes";
    public static final String REMOVED_EQ_DELETES = "removed-equality-deletes";
    public static final String TOTAL_EQ_DELETES = "total-equality-deletes";
    public static final String KEPT_MANIFESTS_COUNT = "manifests-kept";
    public static final String CREATED_MANIFESTS_COUNT = "manifests-created";
    public static final String REPLACED_MANIFESTS_COUNT = "manifests-replaced";
    public static final String PROCESSED_MANIFEST_ENTRY_COUNT = "manifest-entries-processed";

    @Nullable
    public TimerResult totalDuration();

    @Nullable
    public CounterResult attempts();

    @Nullable
    public CounterResult addedDataFiles();

    @Nullable
    public CounterResult removedDataFiles();

    @Nullable
    public CounterResult totalDataFiles();

    @Nullable
    public CounterResult addedDeleteFiles();

    @Nullable
    public CounterResult addedEqualityDeleteFiles();

    @Nullable
    public CounterResult addedPositionalDeleteFiles();

    @Nullable
    @Value.Default
    default public CounterResult addedDVs() {
        return null;
    }

    @Nullable
    public CounterResult removedDeleteFiles();

    @Nullable
    public CounterResult removedEqualityDeleteFiles();

    @Nullable
    public CounterResult removedPositionalDeleteFiles();

    @Nullable
    @Value.Default
    default public CounterResult removedDVs() {
        return null;
    }

    @Nullable
    public CounterResult totalDeleteFiles();

    @Nullable
    public CounterResult addedRecords();

    @Nullable
    public CounterResult removedRecords();

    @Nullable
    public CounterResult totalRecords();

    @Nullable
    public CounterResult addedFilesSizeInBytes();

    @Nullable
    public CounterResult removedFilesSizeInBytes();

    @Nullable
    public CounterResult totalFilesSizeInBytes();

    @Nullable
    public CounterResult addedPositionalDeletes();

    @Nullable
    public CounterResult removedPositionalDeletes();

    @Nullable
    public CounterResult totalPositionalDeletes();

    @Nullable
    public CounterResult addedEqualityDeletes();

    @Nullable
    public CounterResult removedEqualityDeletes();

    @Nullable
    public CounterResult totalEqualityDeletes();

    @Nullable
    @Value.Default
    default public CounterResult manifestsCreated() {
        return null;
    }

    @Nullable
    @Value.Default
    default public CounterResult manifestsReplaced() {
        return null;
    }

    @Nullable
    @Value.Default
    default public CounterResult manifestsKept() {
        return null;
    }

    @Nullable
    @Value.Default
    default public CounterResult manifestEntriesProcessed() {
        return null;
    }

    public static CommitMetricsResult from(CommitMetrics commitMetrics, Map<String, String> snapshotSummary) {
        Preconditions.checkArgument((null != commitMetrics ? 1 : 0) != 0, (Object)"Invalid commit metrics: null");
        Preconditions.checkArgument((null != snapshotSummary ? 1 : 0) != 0, (Object)"Invalid snapshot summary: null");
        return ImmutableCommitMetricsResult.builder().attempts(CounterResult.fromCounter(commitMetrics.attempts())).totalDuration(TimerResult.fromTimer(commitMetrics.totalDuration())).addedDataFiles(CommitMetricsResult.counterFrom(snapshotSummary, ADDED_DATA_FILES)).removedDataFiles(CommitMetricsResult.counterFrom(snapshotSummary, "deleted-data-files")).totalDataFiles(CommitMetricsResult.counterFrom(snapshotSummary, TOTAL_DATA_FILES)).addedDeleteFiles(CommitMetricsResult.counterFrom(snapshotSummary, ADDED_DELETE_FILES)).addedPositionalDeleteFiles(CommitMetricsResult.counterFrom(snapshotSummary, "added-position-delete-files")).addedDVs(CommitMetricsResult.counterFrom(snapshotSummary, ADDED_DVS)).addedEqualityDeleteFiles(CommitMetricsResult.counterFrom(snapshotSummary, ADDED_EQ_DELETE_FILES)).removedDeleteFiles(CommitMetricsResult.counterFrom(snapshotSummary, REMOVED_DELETE_FILES)).removedEqualityDeleteFiles(CommitMetricsResult.counterFrom(snapshotSummary, REMOVED_EQ_DELETE_FILES)).removedPositionalDeleteFiles(CommitMetricsResult.counterFrom(snapshotSummary, "removed-position-delete-files")).removedDVs(CommitMetricsResult.counterFrom(snapshotSummary, REMOVED_DVS)).totalDeleteFiles(CommitMetricsResult.counterFrom(snapshotSummary, TOTAL_DELETE_FILES)).addedRecords(CommitMetricsResult.counterFrom(snapshotSummary, ADDED_RECORDS)).removedRecords(CommitMetricsResult.counterFrom(snapshotSummary, "deleted-records")).totalRecords(CommitMetricsResult.counterFrom(snapshotSummary, TOTAL_RECORDS)).addedFilesSizeInBytes(CommitMetricsResult.counterFrom(snapshotSummary, "added-files-size", MetricsContext.Unit.BYTES)).removedFilesSizeInBytes(CommitMetricsResult.counterFrom(snapshotSummary, "removed-files-size", MetricsContext.Unit.BYTES)).totalFilesSizeInBytes(CommitMetricsResult.counterFrom(snapshotSummary, "total-files-size", MetricsContext.Unit.BYTES)).addedPositionalDeletes(CommitMetricsResult.counterFrom(snapshotSummary, "added-position-deletes")).removedPositionalDeletes(CommitMetricsResult.counterFrom(snapshotSummary, "removed-position-deletes")).totalPositionalDeletes(CommitMetricsResult.counterFrom(snapshotSummary, "total-position-deletes")).addedEqualityDeletes(CommitMetricsResult.counterFrom(snapshotSummary, ADDED_EQ_DELETES)).removedEqualityDeletes(CommitMetricsResult.counterFrom(snapshotSummary, REMOVED_EQ_DELETES)).totalEqualityDeletes(CommitMetricsResult.counterFrom(snapshotSummary, TOTAL_EQ_DELETES)).manifestsCreated(CommitMetricsResult.counterFrom(snapshotSummary, CREATED_MANIFESTS_COUNT)).manifestsReplaced(CommitMetricsResult.counterFrom(snapshotSummary, REPLACED_MANIFESTS_COUNT)).manifestsKept(CommitMetricsResult.counterFrom(snapshotSummary, KEPT_MANIFESTS_COUNT)).manifestEntriesProcessed(CommitMetricsResult.counterFrom(snapshotSummary, "entries-processed")).build();
    }

    public static CounterResult counterFrom(Map<String, String> snapshotSummary, String metricName) {
        return CommitMetricsResult.counterFrom(snapshotSummary, metricName, MetricsContext.Unit.COUNT);
    }

    public static CounterResult counterFrom(Map<String, String> snapshotSummary, String metricName, MetricsContext.Unit unit) {
        if (!snapshotSummary.containsKey(metricName)) {
            return null;
        }
        try {
            return CounterResult.of(unit, Long.parseLong(snapshotSummary.get(metricName)));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

