/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.List;
import java.util.function.Predicate;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class FindTypeVisitor
extends TypeUtil.SchemaVisitor<Type> {
    private final Predicate<Type> predicate;

    FindTypeVisitor(Predicate<Type> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Type schema(Schema schema, Type structResult) {
        return structResult;
    }

    @Override
    public Type struct(Types.StructType struct, List<Type> fieldResults) {
        if (this.predicate.test(struct)) {
            return struct;
        }
        for (Type fieldType : fieldResults) {
            if (fieldType == null) continue;
            return fieldType;
        }
        return null;
    }

    @Override
    public Type field(Types.NestedField field, Type fieldResult) {
        return fieldResult;
    }

    @Override
    public Type list(Types.ListType list, Type elementResult) {
        if (this.predicate.test(list)) {
            return list;
        }
        return elementResult;
    }

    @Override
    public Type map(Types.MapType map, Type keyResult, Type valueResult) {
        if (this.predicate.test(map)) {
            return map;
        }
        if (keyResult != null) {
            return keyResult;
        }
        return valueResult;
    }

    @Override
    public Type variant(Types.VariantType variant) {
        if (this.predicate.test(variant)) {
            return variant;
        }
        return null;
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        if (this.predicate.test(primitive)) {
            return primitive;
        }
        return null;
    }
}

