/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.Buffers;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.function.Supplier;

abstract class BufferHandle
implements Supplier<ByteBuffer> {
    @VisibleForTesting
    BufferHandle() {
    }

    abstract int remaining();

    abstract int capacity();

    abstract int position();

    static BufferHandle allocate(int capacity) {
        return new LazyBufferHandle(capacity, Buffers::allocate);
    }

    static BufferHandle handleOf(ByteBuffer buf) {
        return new EagerBufferHandle(buf);
    }

    static final class LazyBufferHandle
    extends BufferHandle {
        private final int capacity;
        private final Function<Integer, ByteBuffer> factory;
        private volatile ByteBuffer buf;

        @VisibleForTesting
        LazyBufferHandle(int capacity, Function<Integer, ByteBuffer> factory) {
            this.capacity = capacity;
            this.factory = factory;
        }

        @Override
        int remaining() {
            ByteBuffer buffer = this.buf;
            return buffer == null ? this.capacity : buffer.remaining();
        }

        @Override
        int capacity() {
            ByteBuffer buffer = this.buf;
            return buffer == null ? this.capacity : buffer.capacity();
        }

        @Override
        int position() {
            ByteBuffer buffer = this.buf;
            return buffer == null ? 0 : buffer.position();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer get() {
            ByteBuffer result = this.buf;
            if (result != null) {
                return result;
            }
            LazyBufferHandle lazyBufferHandle = this;
            synchronized (lazyBufferHandle) {
                if (this.buf == null) {
                    this.buf = this.factory.apply(this.capacity);
                }
                return this.buf;
            }
        }
    }

    static final class EagerBufferHandle
    extends BufferHandle {
        private final ByteBuffer buf;

        private EagerBufferHandle(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        int remaining() {
            return this.buf.remaining();
        }

        @Override
        int capacity() {
            return this.buf.capacity();
        }

        @Override
        int position() {
            return this.buf.position();
        }

        @Override
        public ByteBuffer get() {
            return this.buf;
        }
    }
}

