/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client.scheduler;

import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.IBatchMutationCallBuilder;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.IBatchCallBuilder;
import org.apache.bifromq.basescheduler.IBatchCallBuilderFactory;

final class BatchMutationCallBuilderFactory<ReqT, RespT, BatchCallT extends BatchMutationCall<ReqT, RespT>>
implements IBatchCallBuilderFactory<ReqT, RespT, MutationCallBatcherKey> {
    private final IBaseKVStoreClient storeClient;
    private final IBatchMutationCallBuilder<ReqT, RespT, BatchCallT> batchCallBuilder;

    BatchMutationCallBuilderFactory(IBaseKVStoreClient storeClient, IBatchMutationCallBuilder<ReqT, RespT, BatchCallT> batchBuilder) {
        this.storeClient = storeClient;
        this.batchCallBuilder = batchBuilder;
    }

    public IBatchCallBuilder<ReqT, RespT, MutationCallBatcherKey> newBuilder(String name, final MutationCallBatcherKey batcherKey) {
        final IMutationPipeline storePipeline = this.storeClient.createMutationPipeline(batcherKey.leaderStoreId);
        return new IBatchCallBuilder<ReqT, RespT, MutationCallBatcherKey>(){

            public IBatchCall<ReqT, RespT, MutationCallBatcherKey> newBatchCall() {
                return BatchMutationCallBuilderFactory.this.batchCallBuilder.newBatchCall(storePipeline, batcherKey);
            }

            public void close() {
                storePipeline.close();
            }
        };
    }
}

