/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import org.apache.bifromq.util.index.ValueStrategy;

final class ValueRef<V> {
    final V value;
    private final ValueStrategy<V> strategy;
    private final int hash;

    private ValueRef(V value, ValueStrategy<V> strategy) {
        this.value = value;
        this.strategy = strategy;
        this.hash = strategy.hash(value);
    }

    static <T> ValueRef<T> of(T value, ValueStrategy<T> strategy) {
        return new ValueRef<T>(value, strategy);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueRef)) {
            return false;
        }
        ValueRef other = (ValueRef)obj;
        ValueRef o = other;
        if (this.strategy != o.strategy) {
            return false;
        }
        return this.strategy.equivalent(this.value, o.value);
    }
}

