/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.RefCounted;

@Internal
public class RefCountedFile
implements RefCounted {
    private final File file;
    private final AtomicInteger references;
    protected boolean closed;

    public RefCountedFile(File file) {
        this.file = Preconditions.checkNotNull(file);
        this.references = new AtomicInteger(1);
        this.closed = false;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void retain() {
        this.references.incrementAndGet();
    }

    @Override
    public boolean release() {
        if (this.references.decrementAndGet() == 0) {
            return this.tryClose();
        }
        return false;
    }

    private boolean tryClose() {
        try {
            Files.deleteIfExists(this.file.toPath());
            return true;
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalError(t);
            return false;
        }
    }

    private void requireOpened() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
    }

    public int getReferenceCounter() {
        return this.references.get();
    }
}

