/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.time.Instant;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class InstantSerializer
extends TypeSerializerSingleton<Instant> {
    private static final long serialVersionUID = -4131715684999061277L;
    static final int SECONDS_BYTES = 8;
    static final int NANOS_BYTES = 4;
    private static final long NULL_SECONDS = Long.MIN_VALUE;
    private static final int NULL_NANOS = Integer.MIN_VALUE;
    public static final InstantSerializer INSTANCE = new InstantSerializer();

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Instant createInstance() {
        return Instant.EPOCH;
    }

    @Override
    public Instant copy(Instant from) {
        return from;
    }

    @Override
    public Instant copy(Instant from, Instant reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 12;
    }

    @Override
    public void serialize(Instant record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeLong(Long.MIN_VALUE);
            target.writeInt(Integer.MIN_VALUE);
        } else {
            target.writeLong(record.getEpochSecond());
            target.writeInt(record.getNano());
        }
    }

    @Override
    public Instant deserialize(DataInputView source) throws IOException {
        long seconds = source.readLong();
        int nanos = source.readInt();
        if (seconds == Long.MIN_VALUE && nanos == Integer.MIN_VALUE) {
            return null;
        }
        return Instant.ofEpochSecond(seconds, nanos);
    }

    @Override
    public Instant deserialize(Instant reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
        target.writeInt(source.readInt());
    }

    @Override
    public TypeSerializerSnapshot<Instant> snapshotConfiguration() {
        return new InstantSerializerSnapshot();
    }

    public static final class InstantSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Instant> {
        public InstantSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

