/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.KeyContextHandler;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;

@Experimental
public abstract class AbstractInput<IN, OUT>
implements Input<IN>,
KeyContextHandler {
    @Nullable
    protected final KeySelector<?, ?> stateKeySelector;
    protected final AbstractStreamOperatorV2<OUT> owner;
    protected final int inputId;
    protected final Output<StreamRecord<OUT>> output;

    public AbstractInput(AbstractStreamOperatorV2<OUT> owner, int inputId) {
        Preconditions.checkArgument((inputId > 0 ? 1 : 0) != 0, (Object)"Inputs are index from 1");
        this.owner = owner;
        this.inputId = inputId;
        this.stateKeySelector = owner.config.getStatePartitioner(inputId - 1, owner.getUserCodeClassloader());
        this.output = owner.output;
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        this.owner.reportWatermark(mark, this.inputId);
    }

    @Override
    public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
        this.owner.reportOrForwardLatencyMarker(latencyMarker);
    }

    @Override
    public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
        this.owner.processWatermarkStatus(watermarkStatus, this.inputId);
    }

    @Override
    public void setKeyContextElement(StreamRecord record) throws Exception {
        this.owner.internalSetKeyContextElement(record, this.stateKeySelector);
    }

    @Override
    public void processRecordAttributes(RecordAttributes recordAttributes) throws Exception {
        this.owner.processRecordAttributes(recordAttributes, this.inputId);
    }

    @Override
    public boolean hasKeyContext() {
        return this.stateKeySelector != null;
    }
}

