/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.spark.stateful.SparkTimerInternals;
import org.apache.beam.runners.spark.translation.AbstractInOutIterator;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.Function3;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.State;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.reflect.ClassTag;
import scala.runtime.AbstractFunction3;

public class TimerUtils {
    public static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY_BYTE_ARRAY = new byte[0];
    public static final @UnknownKeyFor @NonNull @Initialized TimerMarker TIMER_MARKER = new TimerMarker();

    public static <W extends BoundedWindow> void triggerExpiredTimers(@UnknownKeyFor @NonNull @Initialized SparkTimerInternals sparkTimerInternals, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AbstractInOutIterator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> abstractInOutIterator) {
        Collection<TimerInternals.TimerData> expiredTimers = TimerUtils.getExpiredTimers(sparkTimerInternals, windowingStrategy);
        if (!expiredTimers.isEmpty()) {
            expiredTimers.forEach(abstractInOutIterator::fireTimer);
        }
    }

    public static <W extends BoundedWindow> void dropExpiredTimers(@UnknownKeyFor @NonNull @Initialized SparkTimerInternals sparkTimerInternals, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        Collection<TimerInternals.TimerData> expiredTimers = TimerUtils.getExpiredTimers(sparkTimerInternals, windowingStrategy);
        if (!expiredTimers.isEmpty()) {
            expiredTimers.forEach(sparkTimerInternals::deleteTimer);
        }
    }

    private static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized Collection<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> getExpiredTimers(@UnknownKeyFor @NonNull @Initialized SparkTimerInternals sparkTimerInternals, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return sparkTimerInternals.getTimers().stream().filter(timer -> timer.getTimestamp().plus((ReadableDuration)windowingStrategy.getAllowedLateness()).isBefore((ReadableInstant)(timer.getDomain().equals((Object)TimeDomain.PROCESSING_TIME) ? sparkTimerInternals.currentProcessingTime() : sparkTimerInternals.currentInputWatermarkTime()))).collect(Collectors.toList());
    }

    public static <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized JavaDStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>> toPeriodicDStream(@UnknownKeyFor @NonNull @Initialized JavaDStream<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>>> originalLRDD) {
        JavaPairDStream uniqueKeysDStream = originalLRDD.mapPartitionsToPair((PairFlatMapFunction & Serializable)iterator -> {
            HashSet<Object> uniqueKeys = new HashSet<Object>();
            while (iterator.hasNext()) {
                KV kv = (KV)((WindowedValue)iterator.next()).getValue();
                uniqueKeys.add(kv.getKey());
            }
            return Iterators.transform(uniqueKeys.iterator(), key -> Tuple2.apply(null, (Object)key));
        });
        JavaPairDStream keyStateSnapshotDStream = uniqueKeysDStream.mapWithState(StateSpec.function((scala.Function3)new SerializableFunction3<KeyT, Option<KeyT>, State<Set<KeyT>>, Void>(){

            public @UnknownKeyFor @Nullable @Initialized Void apply(KeyT timerKeyMarker, @UnknownKeyFor @NonNull @Initialized Option<KeyT> actualKey, @UnknownKeyFor @NonNull @Initialized State<@UnknownKeyFor @NonNull @Initialized Set<KeyT>> state) {
                HashSet<Object> keyState = state.exists() ? (HashSet<Object>)state.get() : new HashSet<Object>();
                keyState.add(actualKey.get());
                state.update(keyState);
                return null;
            }
        })).stateSnapshots();
        return originalLRDD.transformWith(keyStateSnapshotDStream, (Function3 & Serializable)(wvRDD, stateRDD, time) -> {
            int numPartitions = wvRDD.getNumPartitions();
            HashSet keySet = new HashSet();
            stateRDD.distinct().values().collect().forEach(keySet::addAll);
            List collect = keySet.stream().map(key -> new WindowedValueForTimerMarker<KV>(KV.of((Object)key, (Object)TIMER_MARKER))).collect(Collectors.toList());
            JavaRDD keyConvertedRDD = JavaRDD.fromRDD((RDD)stateRDD.context().parallelize(JavaConverters.asScalaIterator(collect.iterator()).toSeq(), numPartitions > 0 ? numPartitions : 1, JavaSparkContext$.MODULE$.fakeClassTag()), (ClassTag)JavaSparkContext$.MODULE$.fakeClassTag());
            return wvRDD.union(keyConvertedRDD);
        });
    }

    private static class WindowedValueForTimerMarker<@UnknownKeyFor T>
    implements Serializable,
    WindowedValue<T> {
        private final T value;

        public WindowedValueForTimerMarker(T value) {
            this.value = value;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPaneInfo() {
            return PaneInfo.NO_FIRING;
        }

        public @Nullable @UnknownKeyFor @Initialized String getRecordId() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean causedByDrain() {
            return false;
        }

        public @Nullable @UnknownKeyFor @Initialized Long getRecordOffset() {
            return null;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> explodeWindows() {
            return Collections.emptyList();
        }

        @Pure
        public T getValue() {
            return this.value;
        }

        @Pure
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new WindowedValueForTimerMarker<NewT>(newValue);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return Collections.emptyList();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof WindowedValueForTimerMarker) {
                WindowedValueForTimerMarker that = (WindowedValueForTimerMarker)o;
                return Objects.equals(this.getValue(), that.getValue());
            }
            return super.equals(o);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue());
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("pane", (Object)this.getPaneInfo()).toString();
        }
    }

    public static class TimerMarker
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "TIMER_MARKER";
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            return o instanceof TimerMarker;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return 1;
        }
    }

    static abstract class SerializableFunction3<@UnknownKeyFor T1, @UnknownKeyFor T2, @UnknownKeyFor T3, @UnknownKeyFor ReturnT>
    extends AbstractFunction3<T1, T2, T3, ReturnT>
    implements Serializable {
        SerializableFunction3() {
        }
    }
}

