/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import io.grpc.s2a.internal.handshaker.OffloadPrivateKeyOperationReq;
import io.grpc.s2a.internal.handshaker.S2AConnectionException;
import io.grpc.s2a.internal.handshaker.S2AIdentity;
import io.grpc.s2a.internal.handshaker.S2AStub;
import io.grpc.s2a.internal.handshaker.SessionReq;
import io.grpc.s2a.internal.handshaker.SessionResp;
import io.grpc.s2a.internal.handshaker.SignatureAlgorithm;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLEngine;

@NotThreadSafe
final class S2APrivateKeyMethod
implements OpenSslPrivateKeyMethod {
    private final S2AStub stub;
    private final Optional<S2AIdentity> localIdentity;
    private static final ImmutableMap<Integer, SignatureAlgorithm> OPENSSL_TO_S2A_SIGNATURE_ALGORITHM_MAP = ImmutableMap.of((Object)OpenSslPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA256, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_RSA_PKCS1_SHA256), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA384, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_RSA_PKCS1_SHA384), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA512, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_RSA_PKCS1_SHA512), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_ECDSA_SECP256R1_SHA256, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_ECDSA_SECP256R1_SHA256), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_ECDSA_SECP384R1_SHA384, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_ECDSA_SECP384R1_SHA384), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_ECDSA_SECP521R1_SHA512, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_ECDSA_SECP521R1_SHA512), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA256, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_RSA_PSS_RSAE_SHA256), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA384, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_RSA_PSS_RSAE_SHA384), (Object)OpenSslPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA512, (Object)((Object)SignatureAlgorithm.S2A_SSL_SIGN_RSA_PSS_RSAE_SHA512));

    public static S2APrivateKeyMethod create(S2AStub stub, Optional<S2AIdentity> localIdentity) {
        Preconditions.checkNotNull((Object)stub);
        return new S2APrivateKeyMethod(stub, localIdentity);
    }

    private S2APrivateKeyMethod(S2AStub stub, Optional<S2AIdentity> localIdentity) {
        this.stub = stub;
        this.localIdentity = localIdentity;
    }

    @VisibleForTesting
    static SignatureAlgorithm convertOpenSslSignAlgToS2ASignAlg(int signatureAlgorithm) {
        SignatureAlgorithm sig = (SignatureAlgorithm)((Object)OPENSSL_TO_S2A_SIGNATURE_ALGORITHM_MAP.get((Object)signatureAlgorithm));
        if (sig == null) {
            throw new UnsupportedOperationException(String.format("Signature Algorithm %d is not supported.", signatureAlgorithm));
        }
        return sig;
    }

    public byte[] sign(SSLEngine engine, int signatureAlgorithm, byte[] input) throws IOException, InterruptedException {
        SessionResp resp;
        Preconditions.checkArgument((input.length > 0 ? 1 : 0) != 0, (Object)"No bytes to sign.");
        SignatureAlgorithm s2aSignatureAlgorithm = S2APrivateKeyMethod.convertOpenSslSignAlgToS2ASignAlg(signatureAlgorithm);
        SessionReq.Builder reqBuilder = SessionReq.newBuilder().setOffloadPrivateKeyOperationReq(OffloadPrivateKeyOperationReq.newBuilder().setOperation(OffloadPrivateKeyOperationReq.PrivateKeyOperation.SIGN).setSignatureAlgorithm(s2aSignatureAlgorithm).setRawBytes(ByteString.copyFrom((byte[])input)));
        if (this.localIdentity.isPresent()) {
            reqBuilder.setLocalIdentity(this.localIdentity.get().getIdentity());
        }
        if ((resp = this.stub.send(reqBuilder.build())).hasStatus() && resp.getStatus().getCode() != 0) {
            throw new S2AConnectionException(String.format("Error occurred in response from S2A, error code: %d, error message: \"%s\".", resp.getStatus().getCode(), resp.getStatus().getDetails()));
        }
        if (!resp.hasOffloadPrivateKeyOperationResp()) {
            throw new S2AConnectionException("No valid response received from S2A.");
        }
        return resp.getOffloadPrivateKeyOperationResp().getOutBytes().toByteArray();
    }

    public byte[] decrypt(SSLEngine engine, byte[] input) {
        throw new UnsupportedOperationException("decrypt is not supported.");
    }
}

