/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.actions.constraint;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.actions.constraint.ConstraintUpdate;
import org.apache.hop.neo4j.actions.constraint.ObjectType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;

@Action(id="NEO4J_CONSTRAINT", name="Neo4j Constraint", description="Create or delete constraints in a Neo4j database", image="neo4j_constraint.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", keywords={"i18n::Neo4jConstraint.keyword"}, documentationUrl="/workflow/actions/neo4j-constraint.html")
public class Neo4jConstraint
extends ActionBase
implements IAction {
    @HopMetadataProperty(key="connection", storeWithName=true)
    private NeoConnection connection;
    @HopMetadataProperty(groupKey="updates", key="update")
    private List<ConstraintUpdate> constraintUpdates = new ArrayList<ConstraintUpdate>();

    public Neo4jConstraint() {
        this("", "");
    }

    public Neo4jConstraint(String name) {
        this(name, "");
    }

    public Neo4jConstraint(String name, String description) {
        super(name, description);
    }

    public org.apache.hop.core.Result execute(org.apache.hop.core.Result result, int nr) throws HopException {
        if (this.connection == null) {
            result.setResult(false);
            result.increaseErrors(1L);
            throw new HopException("Please specify a Neo4j connection to use");
        }
        for (ConstraintUpdate constraintUpdate : this.constraintUpdates) {
            if (constraintUpdate.getUpdateType() == null) {
                throw new HopException("Please make sure to always specify a constraint update type");
            }
            switch (constraintUpdate.getUpdateType()) {
                case DROP: {
                    this.dropConstraint(constraintUpdate);
                    break;
                }
            }
        }
        for (ConstraintUpdate constraintUpdate : this.constraintUpdates) {
            switch (constraintUpdate.getUpdateType()) {
                case CREATE: {
                    this.createConstraint(constraintUpdate);
                    break;
                }
            }
        }
        return result;
    }

    public static String generateDropConstraintCypher(ConstraintUpdate constraintUpdate) throws HopException {
        Object cypher = "DROP CONSTRAINT ";
        if (!StringUtils.isNotEmpty((String)constraintUpdate.getConstraintName())) {
            throw new HopException("Please drop constraint on relationship properties with the name of the constraint. This was for label: " + constraintUpdate.getObjectName() + ", properties: " + constraintUpdate.getObjectProperties());
        }
        cypher = (String)cypher + constraintUpdate.getConstraintName();
        cypher = (String)cypher + " IF EXISTS ";
        return cypher;
    }

    private void dropConstraint(ConstraintUpdate constraintUpdate) throws HopException {
        String cypher;
        String _cypher = cypher = Neo4jConstraint.generateDropConstraintCypher(constraintUpdate);
        try (Driver driver = this.connection.getDriver(this.getLogChannel(), (IVariables)this);
             Session session = this.connection.getSession(this.getLogChannel(), driver, (IVariables)this);){
            session.executeWrite(tx -> {
                try {
                    this.logDetailed("Dropping constraint with cypher: " + _cypher);
                    Result result = tx.run(_cypher);
                    result.consume();
                    return true;
                }
                catch (Throwable e) {
                    this.logError("Error dropping constraint with cypher [" + _cypher + "]", e);
                    return false;
                }
            });
        }
    }

    public static String generateCreateConstraintCypher(ConstraintUpdate constraintUpdate) throws HopException {
        Object cypher;
        block16: {
            block15: {
                cypher = "CREATE CONSTRAINT ";
                if (!StringUtils.isNotEmpty((String)constraintUpdate.getConstraintName())) {
                    throw new HopException("Please create constraints on relationship properties with a name for the constraint. This was for label: " + constraintUpdate.getObjectName() + ", properties: " + constraintUpdate.getObjectProperties());
                }
                cypher = (String)cypher + constraintUpdate.getConstraintName();
                cypher = (String)cypher + " IF NOT EXISTS FOR ";
                if (constraintUpdate.getObjectType() != ObjectType.NODE) break block15;
                cypher = (String)cypher + "(n:" + constraintUpdate.getObjectName() + ") ";
                cypher = (String)cypher + "REQUIRE ";
                switch (constraintUpdate.getConstraintType()) {
                    case UNIQUE: {
                        cypher = (String)cypher + " n." + constraintUpdate.getObjectProperties() + " IS UNIQUE ";
                        break block16;
                    }
                    case NOT_NULL: {
                        cypher = (String)cypher + " n." + constraintUpdate.getObjectProperties() + " IS NOT NULL ";
                        break block16;
                    }
                    case NODE_KEY: {
                        String properties = constraintUpdate.getObjectProperties();
                        if (StringUtils.isEmpty((String)properties)) {
                            throw new HopException("NODE_KEY constraint requires at least one property. Properties: " + properties);
                        }
                        String[] props = properties.split(",");
                        if (props.length < 1) {
                            throw new HopException("NODE_KEY constraint requires at least one property. Properties: " + properties);
                        }
                        StringBuilder propsList = new StringBuilder("(");
                        for (int i = 0; i < props.length; ++i) {
                            if (i > 0) {
                                propsList.append(", ");
                            }
                            propsList.append("n.").append(props[i].trim());
                        }
                        propsList.append(")");
                        cypher = (String)cypher + propsList.toString() + " IS NODE KEY ";
                        break block16;
                    }
                    default: {
                        throw new HopException("Unsupported constraint type: " + String.valueOf((Object)constraintUpdate.getConstraintType()));
                    }
                }
            }
            cypher = (String)cypher + "()-[r:" + constraintUpdate.getObjectName() + "]-() ";
            cypher = (String)cypher + "REQUIRE ";
            switch (constraintUpdate.getConstraintType()) {
                case UNIQUE: {
                    cypher = (String)cypher + " r." + constraintUpdate.getObjectProperties() + " IS UNIQUE ";
                    break;
                }
                case NOT_NULL: {
                    cypher = (String)cypher + " r." + constraintUpdate.getObjectProperties() + " IS NOT NULL ";
                    break;
                }
                case NODE_KEY: {
                    throw new HopException("NODE_KEY constraint type is only supported for nodes, not relationships");
                }
                default: {
                    throw new HopException("Unsupported constraint type: " + String.valueOf((Object)constraintUpdate.getConstraintType()));
                }
            }
        }
        return cypher;
    }

    private void createConstraint(ConstraintUpdate constraintUpdate) throws HopException {
        String cypher;
        String _cypher = cypher = Neo4jConstraint.generateCreateConstraintCypher(constraintUpdate);
        try (Driver driver = this.connection.getDriver(this.getLogChannel(), (IVariables)this);
             Session session = this.connection.getSession(this.getLogChannel(), driver, (IVariables)this);){
            session.executeWrite(tx -> {
                try {
                    this.logDetailed("Creating constraint with cypher: " + _cypher);
                    Result result = tx.run(_cypher);
                    result.consume();
                    return true;
                }
                catch (Throwable e) {
                    this.logError("Error creating constraint with cypher [" + _cypher + "]", e);
                    return false;
                }
            });
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public NeoConnection getConnection() {
        return this.connection;
    }

    public void setConnection(NeoConnection connection) {
        this.connection = connection;
    }

    public List<ConstraintUpdate> getConstraintUpdates() {
        return this.constraintUpdates;
    }

    public void setConstraintUpdates(List<ConstraintUpdate> constraintUpdates) {
        this.constraintUpdates = constraintUpdates;
    }
}

