/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.anthropic.AnthropicClientBuilderFactory;
import dev.langchain4j.model.anthropic.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.DefaultAnthropicClient;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;

public abstract class AnthropicClient {
    public abstract AnthropicCreateMessageResponse createMessage(AnthropicCreateMessageRequest var1);

    public abstract void createMessage(AnthropicCreateMessageRequest var1, StreamingResponseHandler<AiMessage> var2);

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(AnthropicClientBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            AnthropicClientBuilderFactory factory = (AnthropicClientBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return DefaultAnthropicClient.builder();
    }

    public static abstract class Builder<T extends AnthropicClient, B extends Builder<T, B>> {
        protected String baseUrl;
        protected String apiKey;
        protected String version;
        protected Duration timeout;
        protected Boolean logRequests;
        protected Boolean logResponses;

        public abstract T build();

        public B baseUrl(String baseUrl) {
            if (baseUrl == null || baseUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("baseUrl cannot be null or empty");
            }
            this.baseUrl = baseUrl;
            return (B)this;
        }

        public B apiKey(String apiKey) {
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("Anthropic API Key must be defined.");
            }
            this.apiKey = apiKey;
            return (B)this;
        }

        public B version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("version cannot be null or empty");
            }
            this.version = version;
            return (B)this;
        }

        public B timeout(Duration timeout) {
            if (timeout == null) {
                throw new IllegalArgumentException("timeout cannot be null");
            }
            this.timeout = timeout;
            return (B)this;
        }

        public B logRequests() {
            return this.logRequests(true);
        }

        public B logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return (B)this;
        }

        public B logResponses() {
            return this.logResponses(true);
        }

        public B logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return (B)this;
        }
    }
}

