/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.csvinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IInputFileMeta;
import org.apache.hop.core.file.TextFileInputField;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.common.ICsvInputAwareMeta;
import org.apache.hop.pipeline.transforms.csvinput.CsvInput;
import org.apache.hop.pipeline.transforms.csvinput.CsvInputData;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="CsvInputMeta.Injection.", groups={"INPUT_FIELDS"})
@Transform(id="CSVInput", image="textfileinput.svg", name="i18n::CsvInput.Name", description="i18n::CsvInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::CsvInputMeta.keyword"}, documentationUrl="/pipeline/transforms/csvinput.html")
public class CsvInputMeta
extends BaseTransformMeta<CsvInput, CsvInputData>
implements IInputFileMeta,
ICsvInputAwareMeta {
    private static final Class<?> PKG = CsvInput.class;
    public static final String CONST_FIELDS = "fields";
    public static final String CONST_FIELD = "field";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_SPACES_LONG = "        ";
    @Injection(name="FILENAME")
    private String filename;
    @Injection(name="FILENAME_FIELD")
    private String filenameField;
    @Injection(name="INCLUDE_FILENAME")
    private boolean includingFilename;
    @Injection(name="ROW_NUMBER_FIELDNAME")
    private String rowNumField;
    @Injection(name="HEADER_PRESENT")
    private boolean headerPresent;
    @Injection(name="DELIMITER")
    private String delimiter;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="BREAK_IN_ENCLOSURE")
    public boolean breakInEnclosureAllowed;
    @Injection(name="BUFFER_SIZE")
    private String bufferSize;
    @Injection(name="LAZY_CONVERSION")
    private boolean lazyConversionActive;
    @InjectionDeep
    private TextFileInputField[] inputFields;
    @Injection(name="ADD_RESULT")
    private boolean addResult;
    @Injection(name="RUNNING_IN_PARALLEL")
    private boolean runningInParallel;
    @Injection(name="FILE_ENCODING")
    private String encoding;
    @Injection(name="NEWLINES_IN_FIELDS")
    private boolean newlinePossibleInFields;
    @Injection(name="SCHEMA_DEFINITION")
    private String schemaDefinition;
    @Injection(name="IGNORE_FIELDS")
    public boolean ignoreFields;

    public CsvInputMeta() {
        this.allocate(0);
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        CsvInputMeta retval = (CsvInputMeta)((Object)super.clone());
        retval.inputFields = new TextFileInputField[this.inputFields.length];
        for (int i = 0; i < this.inputFields.length; ++i) {
            retval.inputFields[i] = (TextFileInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    public void setDefault() {
        this.delimiter = ",";
        this.enclosure = "\"";
        this.headerPresent = true;
        this.lazyConversionActive = true;
        this.addResult = false;
        this.bufferSize = "50000";
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.filename = XmlHandler.getTagValue((Node)transformNode, (String)"filename");
            this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)"filename_field");
            this.rowNumField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.includingFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_filename"));
            this.delimiter = XmlHandler.getTagValue((Node)transformNode, (String)"separator");
            this.enclosure = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure");
            this.bufferSize = XmlHandler.getTagValue((Node)transformNode, (String)"buffer_size");
            this.schemaDefinition = XmlHandler.getTagValue((Node)transformNode, (String)"schemaDefinition");
            this.ignoreFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"ignoreFields"));
            this.headerPresent = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"header"));
            this.lazyConversionActive = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"lazy_conversion"));
            this.addResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"add_filename_result"));
            this.runningInParallel = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"parallel"));
            String nlp = XmlHandler.getTagValue((Node)transformNode, (String)"newline_possible");
            this.newlinePossibleInFields = Utils.isEmpty((CharSequence)nlp) ? !this.runningInParallel : "Y".equalsIgnoreCase(nlp);
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)CONST_FIELDS);
            int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                this.inputFields[i] = new TextFileInputField();
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.inputFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                this.inputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                this.inputFields[i].setTrimType(ValueMetaBase.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrFields) {
        this.inputFields = new TextFileInputField[nrFields];
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filename_field", (String)this.filenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_filename", (boolean)this.includingFilename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"separator", (String)this.delimiter));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XmlHandler.addTagValue((String)"header", (boolean)this.headerPresent));
        retval.append("    ").append(XmlHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"schemaDefinition", (String)this.schemaDefinition));
        retval.append("    ").append(XmlHandler.addTagValue((String)"ignoreFields", (boolean)this.ignoreFields));
        retval.append("    ").append(XmlHandler.addTagValue((String)"lazy_conversion", (boolean)this.lazyConversionActive));
        retval.append("    ").append(XmlHandler.addTagValue((String)"add_filename_result", (boolean)this.addResult));
        retval.append("    ").append(XmlHandler.addTagValue((String)"parallel", (boolean)this.runningInParallel));
        retval.append("    ").append(XmlHandler.addTagValue((String)"newline_possible", (boolean)this.newlinePossibleInFields));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XmlHandler.openTag((String)CONST_FIELDS)).append(Const.CR);
        for (TextFileInputField field : this.inputFields) {
            retval.append(CONST_SPACES).append(XmlHandler.openTag((String)CONST_FIELD)).append(Const.CR);
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)field.getType())));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append(CONST_SPACES_LONG).append(XmlHandler.addTagValue((String)"trim_type", (String)ValueMetaBase.getTrimTypeCode((int)field.getTrimType())));
            retval.append(CONST_SPACES).append(XmlHandler.closeTag((String)CONST_FIELD)).append(Const.CR);
        }
        retval.append("    ").append(XmlHandler.closeTag((String)CONST_FIELDS)).append(Const.CR);
        return retval.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            rowMeta.clear();
            if (this.ignoreFields) {
                try {
                    loadedSchemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(metadataProvider, this.getSchemaDefinition());
                    if (loadedSchemaDefinition == null || (r = loadedSchemaDefinition.getRowMeta()) == null) ** GOTO lbl42
                    for (i = 0; i < r.size(); ++i) {
                        v = r.getValueMeta(i);
                        if (this.lazyConversionActive) {
                            v.setStorageType(1);
                        }
                        v.setStringEncoding(variables.resolve(this.encoding));
                        storageMetadata = ValueMetaFactory.cloneValueMeta((IValueMeta)v, (int)2);
                        storageMetadata.setStorageType(0);
                        storageMetadata.setLength(-1, -1);
                        v.setStorageMetadata(storageMetadata);
                        v.setOrigin(origin);
                        rowMeta.addValueMeta(v);
                    }
                }
                catch (HopPluginException | HopTransformException loadedSchemaDefinition) {}
            } else {
                for (SchemaDefinition field : this.inputFields) {
                    valueMeta = ValueMetaFactory.createValueMeta((String)field.getName(), (int)field.getType());
                    valueMeta.setConversionMask(field.getFormat());
                    valueMeta.setLength(field.getLength());
                    valueMeta.setPrecision(field.getPrecision());
                    valueMeta.setConversionMask(field.getFormat());
                    valueMeta.setDecimalSymbol(field.getDecimalSymbol());
                    valueMeta.setGroupingSymbol(field.getGroupSymbol());
                    valueMeta.setCurrencySymbol(field.getCurrencySymbol());
                    valueMeta.setTrimType(field.getTrimType());
                    if (this.lazyConversionActive) {
                        valueMeta.setStorageType(1);
                    }
                    valueMeta.setStringEncoding(variables.resolve(this.encoding));
                    storageMetadata = ValueMetaFactory.cloneValueMeta((IValueMeta)valueMeta, (int)2);
                    storageMetadata.setStorageType(0);
                    storageMetadata.setLength(-1, -1);
                    valueMeta.setStorageMetadata(storageMetadata);
                    valueMeta.setOrigin(origin);
                    rowMeta.addValueMeta(valueMeta);
                }
            }
lbl42:
            // 4 sources

            if (!Utils.isEmpty((CharSequence)this.filenameField) && this.includingFilename) {
                filenameMeta = new ValueMetaString(this.filenameField);
                filenameMeta.setOrigin(origin);
                if (this.lazyConversionActive) {
                    filenameMeta.setStorageType(1);
                    filenameMeta.setStorageMetadata((IValueMeta)new ValueMetaString(this.filenameField));
                }
                rowMeta.addValueMeta((IValueMeta)filenameMeta);
            }
            if (!Utils.isEmpty((CharSequence)this.rowNumField)) {
                rowNumMeta = new ValueMetaInteger(this.rowNumField);
                rowNumMeta.setLength(10);
                rowNumMeta.setOrigin(origin);
                rowMeta.addValueMeta((IValueMeta)rowNumMeta);
            }
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CsvInputMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public boolean isBreakInEnclosureAllowed() {
        return this.breakInEnclosureAllowed;
    }

    public void setBreakInEnclosureAllowed(boolean breakInEnclosureAllowed) {
        this.breakInEnclosureAllowed = breakInEnclosureAllowed;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            reference.getEntries().add(new ResourceEntry(variables.resolve(this.filename), ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public TextFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public int getFileFormatTypeNr() {
        return 2;
    }

    public String[] getFilePaths(IVariables variables) {
        return new String[]{variables.resolve(this.filename)};
    }

    public int getNrHeaderLines() {
        return 1;
    }

    public boolean hasHeader() {
        return this.isHeaderPresent();
    }

    public String getErrorCountField() {
        return null;
    }

    public String getErrorFieldsField() {
        return null;
    }

    public String getErrorTextField() {
        return null;
    }

    public String getEscapeCharacter() {
        return null;
    }

    public String getFileType() {
        return "CSV";
    }

    public String getSeparator() {
        return this.delimiter;
    }

    public boolean includeFilename() {
        return false;
    }

    public boolean includeRowNumber() {
        return false;
    }

    public boolean isErrorIgnored() {
        return false;
    }

    public boolean isErrorLineSkipped() {
        return false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject;
            if (Utils.isEmpty((CharSequence)this.filenameField) && !Utils.isEmpty((CharSequence)this.filename) && (fileObject = HopVfs.getFileObject((String)variables.resolve(this.filename), (IVariables)variables)).exists()) {
                this.filename = iResourceNaming.nameResource(fileObject, variables, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public FileObject getHeaderFileObject(IVariables variables) {
        String filename = variables.resolve(this.getFilename());
        try {
            return HopVfs.getFileObject((String)filename, (IVariables)variables);
        }
        catch (HopFileException e) {
            return null;
        }
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public String getFilenameField() {
        return this.filenameField;
    }

    @Generated
    public boolean isIncludingFilename() {
        return this.includingFilename;
    }

    @Generated
    public String getRowNumField() {
        return this.rowNumField;
    }

    @Generated
    public boolean isHeaderPresent() {
        return this.headerPresent;
    }

    @Generated
    public String getBufferSize() {
        return this.bufferSize;
    }

    @Generated
    public boolean isLazyConversionActive() {
        return this.lazyConversionActive;
    }

    @Generated
    public boolean isAddResult() {
        return this.addResult;
    }

    @Generated
    public boolean isRunningInParallel() {
        return this.runningInParallel;
    }

    @Generated
    public boolean isNewlinePossibleInFields() {
        return this.newlinePossibleInFields;
    }

    @Generated
    public String getSchemaDefinition() {
        return this.schemaDefinition;
    }

    @Generated
    public boolean isIgnoreFields() {
        return this.ignoreFields;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    @Generated
    public void setIncludingFilename(boolean includingFilename) {
        this.includingFilename = includingFilename;
    }

    @Generated
    public void setRowNumField(String rowNumField) {
        this.rowNumField = rowNumField;
    }

    @Generated
    public void setHeaderPresent(boolean headerPresent) {
        this.headerPresent = headerPresent;
    }

    @Generated
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Generated
    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    @Generated
    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Generated
    public void setLazyConversionActive(boolean lazyConversionActive) {
        this.lazyConversionActive = lazyConversionActive;
    }

    @Generated
    public void setInputFields(TextFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    @Generated
    public void setAddResult(boolean addResult) {
        this.addResult = addResult;
    }

    @Generated
    public void setRunningInParallel(boolean runningInParallel) {
        this.runningInParallel = runningInParallel;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setNewlinePossibleInFields(boolean newlinePossibleInFields) {
        this.newlinePossibleInFields = newlinePossibleInFields;
    }

    @Generated
    public void setSchemaDefinition(String schemaDefinition) {
        this.schemaDefinition = schemaDefinition;
    }

    @Generated
    public void setIgnoreFields(boolean ignoreFields) {
        this.ignoreFields = ignoreFields;
    }
}

