/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryDynamicReadDescriptor;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldNumber;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class BigQueryDynamicReadDescriptor
implements Serializable {
    @SchemaFieldName(value="query")
    @SchemaFieldNumber(value="0")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized String getQuery();

    @SchemaFieldName(value="table")
    @SchemaFieldNumber(value="1")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized String getTable();

    @SchemaFieldName(value="flattenResults")
    @SchemaFieldNumber(value="2")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized Boolean getFlattenResults();

    @SchemaFieldName(value="legacySql")
    @SchemaFieldNumber(value="3")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized Boolean getUseLegacySql();

    @SchemaFieldName(value="selectedFields")
    @SchemaFieldNumber(value="4")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getSelectedFields();

    @SchemaFieldName(value="rowRestriction")
    @SchemaFieldNumber(value="5")
    @Pure
    abstract @Nullable @UnknownKeyFor @Initialized String getRowRestriction();

    @SchemaCreate
    public static @UnknownKeyFor @NonNull @Initialized BigQueryDynamicReadDescriptor create(@Nullable @UnknownKeyFor @Initialized String query, @Nullable @UnknownKeyFor @Initialized String table, @Nullable @UnknownKeyFor @Initialized Boolean flattenResults, @Nullable @UnknownKeyFor @Initialized Boolean useLegacySql, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields, @Nullable @UnknownKeyFor @Initialized String rowRestriction) {
        Preconditions.checkArgument((query != null || table != null ? 1 : 0) != 0, (Object)"Either query or table has to be specified.");
        Preconditions.checkArgument((query == null || table == null ? 1 : 0) != 0, (Object)"Either query or table has to be specified not both.");
        Preconditions.checkArgument((table == null || flattenResults == null && useLegacySql == null ? 1 : 0) != 0, (Object)"Specifies a table with a result flattening preference or legacySql, which only applies to queries");
        Preconditions.checkArgument((query == null || selectedFields == null && rowRestriction == null ? 1 : 0) != 0, (Object)"Selected fields and row restriction are only applicable for table reads");
        Preconditions.checkArgument((query == null || flattenResults != null && useLegacySql != null ? 1 : 0) != 0, (Object)"If query is used, flattenResults and legacySql have to be set as well.");
        return new AutoValue_BigQueryDynamicReadDescriptor(query, table, flattenResults, useLegacySql, selectedFields, rowRestriction);
    }

    public static @UnknownKeyFor @NonNull @Initialized BigQueryDynamicReadDescriptor query(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized Boolean flattenResults, @UnknownKeyFor @NonNull @Initialized Boolean useLegacySql) {
        return BigQueryDynamicReadDescriptor.create(query, null, flattenResults, useLegacySql, null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized BigQueryDynamicReadDescriptor table(@UnknownKeyFor @NonNull @Initialized String table, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields, @Nullable @UnknownKeyFor @Initialized String rowRestriction) {
        return BigQueryDynamicReadDescriptor.create(null, table, null, null, selectedFields, rowRestriction);
    }
}

