/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TextualIntegerCoder
extends AtomicCoder<Integer> {
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Integer> TYPE_DESCRIPTOR = new TypeDescriptor<Integer>(){};

    public static @UnknownKeyFor @NonNull @Initialized TextualIntegerCoder of() {
        return new TextualIntegerCoder();
    }

    protected TextualIntegerCoder() {
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Integer value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized Integer value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        String textualValue = value.toString();
        StringUtf8Coder.of().encode(textualValue, outStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Integer decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        String textualValue = StringUtf8Coder.of().decode(inStream, context);
        try {
            return Integer.valueOf(textualValue);
        }
        catch (NumberFormatException exn) {
            throw new CoderException("error when decoding a textual integer", exn);
        }
    }

    @Override
    public void verifyDeterministic() {
        StringUtf8Coder.of().verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Integer> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Integer value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        String textualValue = value.toString();
        return StringUtf8Coder.of().getEncodedElementByteSize(textualValue);
    }
}

