/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delay;

import java.util.Locale;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.delay.DelayData;
import org.apache.hop.pipeline.transforms.delay.DelayMeta;

public class Delay
extends BaseTransform<DelayMeta, DelayData> {
    private static final Class<?> PKG = DelayMeta.class;

    public Delay(TransformMeta transformMeta, DelayMeta meta, DelayData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        long delayMillis;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        IRowMeta rowMeta = this.getInputRowMeta();
        if (this.first) {
            this.first = false;
            this.initializeMeta((DelayMeta)this.meta, rowMeta);
        }
        ((DelayData)this.data).timeout = this.resolveTimeout((DelayMeta)this.meta, r);
        ((DelayData)this.data).multiple = this.resolveScaleMultiple((DelayMeta)this.meta, r);
        if (((DelayData)this.data).timeout <= 0L || ((DelayData)this.data).multiple <= 0L) {
            this.putRow(rowMeta, r);
            if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Delay.Log.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
            }
            return true;
        }
        try {
            delayMillis = Math.multiplyExact(((DelayData)this.data).timeout, ((DelayData)this.data).multiple);
        }
        catch (ArithmeticException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.DelayOverflow", (String[])new String[]{Long.toString(((DelayData)this.data).timeout), Long.toString(((DelayData)this.data).multiple)}), (Throwable)e);
        }
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"Delay.Log.TimeOutWithScale", (String[])new String[]{String.valueOf(((DelayData)this.data).timeout), this.getScaleLabel(((DelayData)this.data).multiple), String.valueOf(delayMillis)}));
        }
        this.applyDelay(delayMillis);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"Delay.WaitTimeIsElapsed.Label", (String[])new String[0]));
        }
        this.putRow(rowMeta, r);
        if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"Delay.Log.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
        }
        return true;
    }

    private void initializeMeta(DelayMeta meta, IRowMeta rowMeta) throws HopException {
        ((DelayData)this.data).staticTimeout = Const.toLong((String)this.resolve(meta.getTimeout()), (long)0L);
        ((DelayData)this.data).staticScaleTimeCode = meta.getScaleTimeCode();
        ((DelayData)this.data).multiple = this.determineMultiple(((DelayData)this.data).staticScaleTimeCode);
        if (!Utils.isEmpty((CharSequence)meta.getTimeoutField())) {
            ((DelayData)this.data).timeoutFieldIndex = rowMeta.indexOfValue(meta.getTimeoutField());
            if (((DelayData)this.data).timeoutFieldIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.TimeoutFieldNotFound", (String[])new String[]{meta.getTimeoutField()}));
            }
            ((DelayData)this.data).timeoutValueMeta = rowMeta.getValueMeta(((DelayData)this.data).timeoutFieldIndex);
            if (!((DelayData)this.data).timeoutValueMeta.isNumeric() && ((DelayData)this.data).timeoutValueMeta.getType() != 2) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.TimeoutFieldType", (String[])new String[]{meta.getTimeoutField(), ((DelayData)this.data).timeoutValueMeta.getTypeDesc()}));
            }
        } else {
            ((DelayData)this.data).timeoutFieldIndex = -1;
            ((DelayData)this.data).timeoutValueMeta = null;
        }
        if (meta.isScaleTimeFromField()) {
            if (Utils.isEmpty((CharSequence)meta.getScaleTimeField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.ScaleTimeFieldMissing", (String[])new String[0]));
            }
            ((DelayData)this.data).scaleTimeFieldIndex = rowMeta.indexOfValue(meta.getScaleTimeField());
            if (((DelayData)this.data).scaleTimeFieldIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.ScaleTimeFieldNotFound", (String[])new String[]{meta.getScaleTimeField()}));
            }
            ((DelayData)this.data).scaleTimeValueMeta = rowMeta.getValueMeta(((DelayData)this.data).scaleTimeFieldIndex);
            if (((DelayData)this.data).scaleTimeValueMeta.getType() != 2) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.ScaleTimeFieldType", (String[])new String[]{meta.getScaleTimeField(), ((DelayData)this.data).scaleTimeValueMeta.getTypeDesc()}));
            }
        } else {
            ((DelayData)this.data).scaleTimeFieldIndex = -1;
            ((DelayData)this.data).scaleTimeValueMeta = null;
        }
    }

    private long resolveTimeout(DelayMeta meta, Object[] row) throws HopException {
        if (((DelayData)this.data).timeoutFieldIndex < 0) {
            return Math.max(0L, ((DelayData)this.data).staticTimeout);
        }
        Object timeoutValue = row[((DelayData)this.data).timeoutFieldIndex];
        if (((DelayData)this.data).timeoutValueMeta.isNull(timeoutValue)) {
            return 0L;
        }
        try {
            long timeout;
            Double number = ((DelayData)this.data).timeoutValueMeta.getNumber(timeoutValue);
            if (number == null) {
                String str = ((DelayData)this.data).timeoutValueMeta.getString(timeoutValue);
                if (Utils.isEmpty((CharSequence)str)) {
                    return 0L;
                }
                number = Double.valueOf(str);
            }
            if ((timeout = Math.round(number)) < 0L) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.TimeoutFieldNegative", (Object[])new Object[]{meta.getTimeoutField(), timeout}));
            }
            return timeout;
        }
        catch (NumberFormatException | HopValueException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.TimeoutFieldNotNumeric", (String[])new String[]{meta.getTimeoutField()}), e);
        }
    }

    private long resolveScaleMultiple(DelayMeta meta, Object[] row) throws HopException {
        int scaleCode = ((DelayData)this.data).staticScaleTimeCode;
        if (((DelayData)this.data).scaleTimeFieldIndex >= 0) {
            String value;
            scaleCode = 1;
            Object scaleValue = row[((DelayData)this.data).scaleTimeFieldIndex];
            if (!((DelayData)this.data).scaleTimeValueMeta.isNull(scaleValue) && !Utils.isEmpty((CharSequence)(value = ((DelayData)this.data).scaleTimeValueMeta.getString(scaleValue)))) {
                Integer parsedCode = this.parseScaleTimeCode(value);
                if (parsedCode == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Delay.Log.ScaleTimeFieldInvalid", (String[])new String[]{meta.getScaleTimeField(), value}));
                }
                scaleCode = parsedCode;
            }
        }
        return this.determineMultiple(scaleCode);
    }

    private long determineMultiple(int scaleCode) {
        return switch (scaleCode) {
            case 0 -> 1L;
            case 1 -> 1000L;
            case 2 -> 60000L;
            case 3 -> 3600000L;
            default -> 1000L;
        };
    }

    private String getScaleLabel(long multiple) {
        if (multiple == 1L) {
            return BaseMessages.getString(PKG, (String)"DelayDialog.MSScaleTime.Label", (String[])new String[0]);
        }
        if (multiple == 1000L) {
            return BaseMessages.getString(PKG, (String)"DelayDialog.SScaleTime.Label", (String[])new String[0]);
        }
        if (multiple == 60000L) {
            return BaseMessages.getString(PKG, (String)"DelayDialog.MnScaleTime.Label", (String[])new String[0]);
        }
        if (multiple == 3600000L) {
            return BaseMessages.getString(PKG, (String)"DelayDialog.HrScaleTime.Label", (String[])new String[0]);
        }
        return BaseMessages.getString(PKG, (String)"Delay.Log.UnknownScale", (String[])new String[0]);
    }

    private Integer parseScaleTimeCode(String value) {
        String normalized;
        return switch (normalized = value.trim().toLowerCase(Locale.ROOT)) {
            case "ms", "msec", "millisecond", "milliseconds" -> 0;
            case "s", "sec", "secs", "second", "seconds" -> 1;
            case "m", "min", "mins", "minute", "minutes" -> 2;
            case "h", "hr", "hour", "hours" -> 3;
            default -> null;
        };
    }

    private void applyDelay(long delayMillis) {
        long remaining;
        if (delayMillis <= 0L) {
            return;
        }
        if (delayMillis < 1000L) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return;
        }
        long endTime = System.currentTimeMillis() + delayMillis;
        while (!this.isStopped() && (remaining = endTime - System.currentTimeMillis()) > 0L) {
            long sleepChunk = Math.min(remaining, 1000L);
            try {
                Thread.sleep(sleepChunk);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

