/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.internal;

import com.google.auto.value.AutoValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_Footer;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_IsmRecord;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_IsmShard;
import org.apache.beam.runners.dataflow.internal.AutoValue_IsmFormat_KeyPrefix;
import org.apache.beam.runners.dataflow.util.RandomAccessData;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.HashFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class IsmFormat {
    private static final @UnknownKeyFor @NonNull @Initialized int HASH_SEED = 1225801234;
    private static final @UnknownKeyFor @NonNull @Initialized HashFunction HASH_FUNCTION = Hashing.murmur3_32((int)1225801234);
    public static final @UnknownKeyFor @NonNull @Initialized int SHARD_BITS = 127;
    private static final @UnknownKeyFor @NonNull @Initialized Object METADATA_KEY = new Object(){

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "META";
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return this == obj;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return -1248902349;
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized IsmShard>> ISM_SHARD_INDEX_CODER = ListCoder.of((Coder)IsmShardCoder.of());

    public static void validateCoderIsCompatible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized IsmRecordCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        for (Coder<?> keyComponentCoder : coder.getKeyComponentCoders()) {
            try {
                keyComponentCoder.verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new IllegalArgumentException(String.format("Key component coder %s is expected to be deterministic.", keyComponentCoder), e);
            }
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isMetadataKey(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents) {
        for (Object keyComponent : keyComponents) {
            if (keyComponent != METADATA_KEY) continue;
            return true;
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized Object getMetadataKey() {
        return METADATA_KEY;
    }

    public static final class FooterCoder
    extends AtomicCoder<Footer> {
        private static final @UnknownKeyFor @NonNull @Initialized FooterCoder INSTANCE = new FooterCoder();

        public static @UnknownKeyFor @NonNull @Initialized FooterCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized Footer value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            DataOutputStream dataOut = new DataOutputStream(outStream);
            dataOut.writeLong(value.getIndexPosition());
            dataOut.writeLong(value.getBloomFilterPosition());
            dataOut.writeLong(value.getNumberOfKeys());
            dataOut.write(2);
        }

        public @UnknownKeyFor @NonNull @Initialized Footer decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            DataInputStream dataIn = new DataInputStream(inStream);
            Footer footer = Footer.of(dataIn.readLong(), dataIn.readLong(), dataIn.readLong());
            int version = dataIn.read();
            if (version != 2) {
                throw new IOException("Unknown version " + version + ". Only version 2 is currently supported.");
            }
            return footer;
        }

        public void verifyDeterministic() {
        }

        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized Footer value) {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized Footer value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return 25L;
        }
    }

    @AutoValue
    public static abstract class Footer {
        public static final @UnknownKeyFor @NonNull @Initialized int LONG_BYTES = 8;
        public static final @UnknownKeyFor @NonNull @Initialized int FIXED_LENGTH = 25;
        public static final @UnknownKeyFor @NonNull @Initialized byte VERSION = 2;

        public abstract @UnknownKeyFor @NonNull @Initialized byte getVersion();

        public abstract @UnknownKeyFor @NonNull @Initialized long getIndexPosition();

        public abstract @UnknownKeyFor @NonNull @Initialized long getBloomFilterPosition();

        public abstract @UnknownKeyFor @NonNull @Initialized long getNumberOfKeys();

        public static @UnknownKeyFor @NonNull @Initialized Footer of(@UnknownKeyFor @NonNull @Initialized long indexPosition, @UnknownKeyFor @NonNull @Initialized long bloomFilterPosition, @UnknownKeyFor @NonNull @Initialized long numberOfKeys) {
            return new AutoValue_IsmFormat_Footer(2, indexPosition, bloomFilterPosition, numberOfKeys);
        }
    }

    public static final class KeyPrefixCoder
    extends AtomicCoder<KeyPrefix> {
        private static final @UnknownKeyFor @NonNull @Initialized KeyPrefixCoder INSTANCE = new KeyPrefixCoder();

        public static @UnknownKeyFor @NonNull @Initialized KeyPrefixCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized KeyPrefix value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            VarInt.encode((int)value.getSharedKeySize(), (OutputStream)outStream);
            VarInt.encode((int)value.getUnsharedKeySize(), (OutputStream)outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized KeyPrefix decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return KeyPrefix.of(VarInt.decodeInt((InputStream)inStream), VarInt.decodeInt((InputStream)inStream));
        }

        public void verifyDeterministic() {
        }

        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized KeyPrefix value) {
            return true;
        }

        public @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized KeyPrefix value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Preconditions.checkNotNull((Object)value);
            return (long)VarInt.getLength((int)value.getSharedKeySize()) + (long)VarInt.getLength((int)value.getUnsharedKeySize());
        }
    }

    @AutoValue
    public static abstract class KeyPrefix {
        public abstract @UnknownKeyFor @NonNull @Initialized int getSharedKeySize();

        public abstract @UnknownKeyFor @NonNull @Initialized int getUnsharedKeySize();

        public static @UnknownKeyFor @NonNull @Initialized KeyPrefix of(@UnknownKeyFor @NonNull @Initialized int sharedKeySize, @UnknownKeyFor @NonNull @Initialized int unsharedKeySize) {
            return new AutoValue_IsmFormat_KeyPrefix(sharedKeySize, unsharedKeySize);
        }
    }

    public static class IsmShardCoder
    extends AtomicCoder<IsmShard> {
        private static final @UnknownKeyFor @NonNull @Initialized IsmShardCoder INSTANCE = new IsmShardCoder();

        public static @UnknownKeyFor @NonNull @Initialized IsmShardCoder of() {
            return INSTANCE;
        }

        private IsmShardCoder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized IsmShard value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkState((value.getIndexOffset() >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written without index offset.", (Object)value);
            VarIntCoder.of().encode(Integer.valueOf(value.getId()), outStream);
            VarLongCoder.of().encode(Long.valueOf(value.getBlockOffset()), outStream);
            VarLongCoder.of().encode(Long.valueOf(value.getIndexOffset()), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized IsmShard decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return IsmShard.of(VarIntCoder.of().decode(inStream), VarLongCoder.of().decode(inStream), VarLongCoder.of().decode(inStream));
        }

        public void verifyDeterministic() {
            VarIntCoder.of().verifyDeterministic();
            VarLongCoder.of().verifyDeterministic();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return true;
        }
    }

    @AutoValue
    public static abstract class IsmShard {
        abstract @UnknownKeyFor @NonNull @Initialized int id();

        abstract @UnknownKeyFor @NonNull @Initialized long blockOffset();

        abstract @UnknownKeyFor @NonNull @Initialized long indexOffset();

        IsmShard() {
        }

        public static @UnknownKeyFor @NonNull @Initialized IsmShard of(@UnknownKeyFor @NonNull @Initialized int id, @UnknownKeyFor @NonNull @Initialized long blockOffset) {
            AutoValue_IsmFormat_IsmShard ismShard = new AutoValue_IsmFormat_IsmShard(id, blockOffset, -1L);
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"%s attempting to be written with negative shard id.", (Object)ismShard);
            Preconditions.checkState((blockOffset >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written with negative block offset.", (Object)ismShard);
            return ismShard;
        }

        public static @UnknownKeyFor @NonNull @Initialized IsmShard of(@UnknownKeyFor @NonNull @Initialized int id, @UnknownKeyFor @NonNull @Initialized long blockOffset, @UnknownKeyFor @NonNull @Initialized long indexOffset) {
            AutoValue_IsmFormat_IsmShard ismShard = new AutoValue_IsmFormat_IsmShard(id, blockOffset, indexOffset);
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"%s attempting to be written with negative shard id.", (Object)ismShard);
            Preconditions.checkState((blockOffset >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written with negative block offset.", (Object)ismShard);
            Preconditions.checkState((indexOffset >= 0L ? 1 : 0) != 0, (String)"%s attempting to be written with negative index offset.", (Object)ismShard);
            return ismShard;
        }

        public @UnknownKeyFor @NonNull @Initialized int getId() {
            return this.id();
        }

        public @UnknownKeyFor @NonNull @Initialized long getBlockOffset() {
            return this.blockOffset();
        }

        public @UnknownKeyFor @NonNull @Initialized long getIndexOffset() {
            Preconditions.checkState((this.indexOffset() >= 0L ? 1 : 0) != 0, (Object)"Unable to fetch index offset because it was never specified.");
            return this.indexOffset();
        }

        public @UnknownKeyFor @NonNull @Initialized IsmShard withIndexOffset(@UnknownKeyFor @NonNull @Initialized long indexOffset) {
            return IsmShard.of(this.id(), this.blockOffset(), indexOffset);
        }
    }

    public static class MetadataKeyCoder<@UnknownKeyFor K>
    extends StructuredCoder<K> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;

        public static <K> @UnknownKeyFor @NonNull @Initialized MetadataKeyCoder<K> of(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
            Preconditions.checkNotNull(keyCoder);
            return new MetadataKeyCoder<K>(keyCoder);
        }

        private MetadataKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder() {
            return this.keyCoder;
        }

        public void encode(K value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            if (value == METADATA_KEY) {
                outStream.write(0);
            } else {
                outStream.write(1);
                this.keyCoder.encode(value, outStream);
            }
        }

        public K decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            int marker = inStream.read();
            if (marker == 0) {
                return (K)IsmFormat.getMetadataKey();
            }
            if (marker == 1) {
                return (K)this.keyCoder.decode(inStream);
            }
            throw new CoderException(String.format("Expected marker but got %s.", marker));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return ImmutableList.of(this.keyCoder);
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            MetadataKeyCoder.verifyDeterministic((Coder)this, (String)"Expected key coder to be deterministic", (Coder[])new Coder[]{this.keyCoder});
        }
    }

    public static class IsmRecordCoder<@UnknownKeyFor V>
    extends CustomCoder<IsmRecord<V>> {
        private final @UnknownKeyFor @NonNull @Initialized int numberOfShardKeyCoders;
        private final @UnknownKeyFor @NonNull @Initialized int numberOfMetadataShardKeyCoders;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> keyComponentCoders;
        private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

        public static <V> @UnknownKeyFor @NonNull @Initialized IsmRecordCoder<V> of(@UnknownKeyFor @NonNull @Initialized int numberOfShardKeyCoders, @UnknownKeyFor @NonNull @Initialized int numberOfMetadataShardKeyCoders, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> keyComponentCoders, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            Preconditions.checkNotNull(keyComponentCoders);
            Preconditions.checkArgument((keyComponentCoders.size() > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((numberOfShardKeyCoders > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((numberOfShardKeyCoders <= keyComponentCoders.size() ? 1 : 0) != 0);
            Preconditions.checkArgument((numberOfMetadataShardKeyCoders <= keyComponentCoders.size() ? 1 : 0) != 0);
            return new IsmRecordCoder<V>(numberOfShardKeyCoders, numberOfMetadataShardKeyCoders, keyComponentCoders, valueCoder);
        }

        private IsmRecordCoder(@UnknownKeyFor @NonNull @Initialized int numberOfShardKeyCoders, @UnknownKeyFor @NonNull @Initialized int numberOfMetadataShardKeyCoders, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> keyComponentCoders, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.numberOfShardKeyCoders = numberOfShardKeyCoders;
            this.numberOfMetadataShardKeyCoders = numberOfMetadataShardKeyCoders;
            this.keyComponentCoders = keyComponentCoders;
            this.valueCoder = valueCoder;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getKeyComponentCoders() {
            return this.keyComponentCoders;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getKeyComponentCoder(@UnknownKeyFor @NonNull @Initialized int index) {
            return this.keyComponentCoders.get(index);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<V> getValueCoder() {
            return this.valueCoder;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized IsmRecord<V> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            if (value.getKeyComponents().size() != this.keyComponentCoders.size()) {
                throw new CoderException(String.format("Expected %s key component(s) but received key component(s) %s.", this.keyComponentCoders.size(), value.getKeyComponents()));
            }
            for (int i = 0; i < this.keyComponentCoders.size(); ++i) {
                this.getKeyComponentCoder(i).encode(value.getKeyComponent(i), outStream);
            }
            if (IsmFormat.isMetadataKey(value.getKeyComponents())) {
                ByteArrayCoder.of().encode(value.getMetadata(), outStream);
            } else {
                this.valueCoder.encode(value.getValue(), outStream);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized IsmRecord<V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            ArrayList<Object> keyComponents = new ArrayList<Object>(this.keyComponentCoders.size());
            for (Coder<?> keyCoder : this.keyComponentCoders) {
                keyComponents.add(keyCoder.decode(inStream));
            }
            if (IsmFormat.isMetadataKey(keyComponents)) {
                return IsmRecord.meta(keyComponents, ByteArrayCoder.of().decode(inStream));
            }
            return IsmRecord.of(keyComponents, this.valueCoder.decode(inStream));
        }

        public @UnknownKeyFor @NonNull @Initialized int getNumberOfShardKeyCoders(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents) {
            if (IsmFormat.isMetadataKey(keyComponents)) {
                return this.numberOfMetadataShardKeyCoders;
            }
            return this.numberOfShardKeyCoders;
        }

        public @UnknownKeyFor @NonNull @Initialized int hash(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents) {
            return this.encodeAndHash(keyComponents, new RandomAccessData(), new ArrayList<Integer>());
        }

        public @UnknownKeyFor @NonNull @Initialized int encodeAndHash(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents, @UnknownKeyFor @NonNull @Initialized RandomAccessData keyBytesToMutate) {
            return this.encodeAndHash(keyComponents, keyBytesToMutate, new ArrayList<Integer>());
        }

        public @UnknownKeyFor @NonNull @Initialized int encodeAndHash(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents, @UnknownKeyFor @NonNull @Initialized RandomAccessData keyBytesToMutate, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> keyComponentByteOffsetsToMutate) {
            int shardOffset;
            int numberOfKeyCodersToUse;
            Preconditions.checkNotNull(keyComponents);
            Preconditions.checkArgument((keyComponents.size() <= this.keyComponentCoders.size() ? 1 : 0) != 0, (String)"Expected at most %s key component(s) but received %s.", (int)this.keyComponentCoders.size(), keyComponents);
            if (IsmFormat.isMetadataKey(keyComponents)) {
                numberOfKeyCodersToUse = this.numberOfMetadataShardKeyCoders;
                shardOffset = 128;
            } else {
                numberOfKeyCodersToUse = this.numberOfShardKeyCoders;
                shardOffset = 0;
            }
            Preconditions.checkArgument((numberOfKeyCodersToUse <= keyComponents.size() ? 1 : 0) != 0, (String)"Expected at least %s key component(s) but received %s.", (int)this.numberOfShardKeyCoders, keyComponents);
            try {
                for (int i = 0; i < numberOfKeyCodersToUse; ++i) {
                    this.getKeyComponentCoder(i).encode(keyComponents.get(i), keyBytesToMutate.asOutputStream(), Coder.Context.NESTED);
                    keyComponentByteOffsetsToMutate.add(keyBytesToMutate.size());
                }
                int rval = HASH_FUNCTION.hashBytes(keyBytesToMutate.array(), 0, keyBytesToMutate.size()).asInt() & 0x7F;
                rval += shardOffset;
                for (int i = numberOfKeyCodersToUse; i < keyComponents.size(); ++i) {
                    this.getKeyComponentCoder(i).encode(keyComponents.get(i), keyBytesToMutate.asOutputStream(), Coder.Context.NESTED);
                    keyComponentByteOffsetsToMutate.add(keyBytesToMutate.size());
                }
                return rval;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to hash %s with coder %s", new Object[]{keyComponents, this}), e);
            }
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return ImmutableList.builder().addAll(this.keyComponentCoders).add(this.valueCoder).build();
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            IsmRecordCoder.verifyDeterministic((Coder)this, (String)"Key component coders expected to be deterministic.", this.keyComponentCoders);
            IsmRecordCoder.verifyDeterministic((Coder)this, (String)"Value coder expected to be deterministic.", (Coder[])new Coder[]{this.valueCoder});
        }

        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            for (Coder<?> keyComponentCoder : this.keyComponentCoders) {
                if (keyComponentCoder.consistentWithEquals()) continue;
                return false;
            }
            return this.valueCoder.consistentWithEquals();
        }

        public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized IsmRecord<V> record) {
            Preconditions.checkNotNull(record);
            Preconditions.checkState((record.getKeyComponents().size() == this.keyComponentCoders.size() ? 1 : 0) != 0, (String)"Expected the number of key component coders %s to match the number of key components %s.", (int)this.keyComponentCoders.size(), record.getKeyComponents());
            if (this.consistentWithEquals()) {
                ArrayList<Object> keyComponentStructuralValues = new ArrayList<Object>();
                for (int i = 0; i < this.keyComponentCoders.size(); ++i) {
                    keyComponentStructuralValues.add(this.getKeyComponentCoder(i).structuralValue(record.getKeyComponent(i)));
                }
                if (IsmFormat.isMetadataKey(record.getKeyComponents())) {
                    return IsmRecord.meta(keyComponentStructuralValues, record.getMetadata());
                }
                return IsmRecord.of(keyComponentStructuralValues, this.valueCoder.structuralValue(record.getValue()));
            }
            return super.structuralValue(record);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof IsmRecordCoder)) {
                return false;
            }
            IsmRecordCoder that = (IsmRecordCoder)((Object)other);
            return this.numberOfShardKeyCoders == that.numberOfShardKeyCoders && this.numberOfMetadataShardKeyCoders == that.numberOfMetadataShardKeyCoders && Objects.equals(this.keyComponentCoders, that.keyComponentCoders) && Objects.equals(this.valueCoder, that.valueCoder);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.numberOfShardKeyCoders, this.numberOfMetadataShardKeyCoders, this.keyComponentCoders, this.valueCoder);
        }
    }

    @AutoValue
    public static abstract class IsmRecord<@UnknownKeyFor V> {
        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents();

        abstract @Nullable V value();

        abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] metadata();

        IsmRecord() {
        }

        public static <V> @UnknownKeyFor @NonNull @Initialized IsmRecord<V> of(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents, V value) {
            Preconditions.checkArgument((!keyComponents.isEmpty() ? 1 : 0) != 0, (Object)"Expected non-empty list of key components.");
            Preconditions.checkArgument((!IsmFormat.isMetadataKey(keyComponents) ? 1 : 0) != 0, (Object)"Expected key components to not contain metadata key.");
            return new AutoValue_IsmFormat_IsmRecord<V>(keyComponents, value, null);
        }

        public static <V> @UnknownKeyFor @NonNull @Initialized IsmRecord<V> meta(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> keyComponents, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] metadata) {
            Preconditions.checkNotNull((Object)metadata);
            Preconditions.checkArgument((!keyComponents.isEmpty() ? 1 : 0) != 0, (Object)"Expected non-empty list of key components.");
            Preconditions.checkArgument((boolean)IsmFormat.isMetadataKey(keyComponents), (Object)"Expected key components to contain metadata key.");
            return new AutoValue_IsmFormat_IsmRecord<Object>(keyComponents, null, metadata);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getKeyComponents() {
            return this.keyComponents();
        }

        public @UnknownKeyFor @NonNull @Initialized Object getKeyComponent(@UnknownKeyFor @NonNull @Initialized int index) {
            return this.keyComponents().get(index);
        }

        public V getValue() {
            Preconditions.checkState((!IsmFormat.isMetadataKey(this.keyComponents()) ? 1 : 0) != 0, (Object)"This is a metadata record and not a value record.");
            return this.value();
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getMetadata() {
            Preconditions.checkState((boolean)IsmFormat.isMetadataKey(this.keyComponents()), (Object)"This is a value record and not a metadata record.");
            return this.metadata();
        }
    }
}

