/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import lombok.Generated;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HopToolTip {
    private final Shell tipShell;
    private final Label tipLabel;
    private boolean autoHide = true;

    public HopToolTip(Shell parent) {
        this.tipShell = new Shell(parent, 540676);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.tipShell.setLayout((Layout)layout);
        this.tipLabel = new Label((Composite)this.tipShell, 0);
        GuiResource gui = GuiResource.getInstance();
        if (PropsUi.getInstance().isDarkMode()) {
            this.tipShell.setBackground(gui.getColor(32, 31, 27));
            this.tipLabel.setBackground(gui.getColor(32, 31, 27));
            this.tipLabel.setForeground(gui.getColor(224, 224, 224));
        } else {
            this.tipShell.setBackground(gui.getColorWhite());
            this.tipLabel.setBackground(gui.getColorWhite());
            this.tipLabel.setForeground(gui.getColorBlack());
        }
        Display.getCurrent().addFilter(3, event -> {
            if (this.autoHide && !this.tipShell.isDisposed() && this.tipShell.isVisible()) {
                this.setVisible(false);
            }
        });
    }

    public void setText(String text) {
        if (this.tipLabel != null && !this.tipLabel.isDisposed()) {
            this.tipLabel.setText(text != null ? text : "");
            this.tipShell.pack();
        }
    }

    public String getText() {
        if (this.tipLabel != null && !this.tipLabel.isDisposed()) {
            return this.tipLabel.getText();
        }
        return "";
    }

    public void setLocation(int x, int y) {
        if (this.tipShell != null && !this.tipShell.isDisposed()) {
            this.tipShell.setLocation(x, y);
        }
    }

    public void setLocation(Point location) {
        this.setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        if (this.tipShell != null && !this.tipShell.isDisposed()) {
            this.tipShell.setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.tipShell != null && !this.tipShell.isDisposed() && this.tipShell.isVisible();
    }

    public void dispose() {
        if (this.tipShell != null && !this.tipShell.isDisposed()) {
            this.tipShell.dispose();
        }
    }

    public boolean isDisposed() {
        return this.tipShell == null || this.tipShell.isDisposed();
    }

    @Generated
    public void setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
    }
}

