/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.jaxrs;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.HopServerSingleton;
import org.apache.hop.www.jaxrs.NVPair;
import org.apache.hop.www.jaxrs.PipelineResource;
import org.apache.hop.www.jaxrs.PipelineStatus;
import org.apache.hop.www.jaxrs.ServerStatus;
import org.apache.hop.www.jaxrs.WorkflowResource;
import org.apache.hop.www.jaxrs.WorkflowStatus;

@Path(value="/carte")
public class HopServerResource {
    public static IPipelineEngine<PipelineMeta> getPipeline(String id) {
        return HopServerSingleton.getInstance().getPipelineMap().getPipeline(HopServerResource.getHopServerObjectEntry(id));
    }

    public static IWorkflowEngine<WorkflowMeta> getWorkflow(String id) {
        return HopServerSingleton.getInstance().getWorkflowMap().getWorkflow(HopServerResource.getHopServerObjectEntry(id));
    }

    public static HopServerObjectEntry getHopServerObjectEntry(String id) {
        List<HopServerObjectEntry> pipelineList = HopServerSingleton.getInstance().getPipelineMap().getPipelineObjects();
        for (HopServerObjectEntry entry : pipelineList) {
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        List<HopServerObjectEntry> workflowList = HopServerSingleton.getInstance().getWorkflowMap().getWorkflowObjects();
        for (HopServerObjectEntry entry : workflowList) {
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        return null;
    }

    @GET
    @Path(value="/systemInfo")
    @Produces(value={"application/json"})
    public ServerStatus getSystemInfo() {
        ServerStatus serverStatus = new ServerStatus();
        serverStatus.setStatusDescription("Online");
        return serverStatus;
    }

    @GET
    @Path(value="/configDetails")
    @Produces(value={"application/json"})
    public List<NVPair> getConfigDetails() {
        HopServerConfig serverConfig = HopServerSingleton.getInstance().getPipelineMap().getHopServerConfig();
        ArrayList<NVPair> list = new ArrayList<NVPair>();
        list.add(new NVPair("maxLogLines", "" + serverConfig.getMaxLogLines()));
        list.add(new NVPair("maxLogLinesAge", "" + serverConfig.getMaxLogTimeoutMinutes()));
        list.add(new NVPair("maxObjectsAge", "" + serverConfig.getObjectTimeoutMinutes()));
        list.add(new NVPair("configFile", serverConfig.getFilename()));
        return list;
    }

    @GET
    @Path(value="/pipelines")
    @Produces(value={"application/json"})
    public List<HopServerObjectEntry> getPipelines() {
        return HopServerSingleton.getInstance().getPipelineMap().getPipelineObjects();
    }

    @GET
    @Path(value="/pipelines/detailed")
    @Produces(value={"application/json"})
    public List<PipelineStatus> getPipelineDetails() {
        List<HopServerObjectEntry> pipelineEntries = HopServerSingleton.getInstance().getPipelineMap().getPipelineObjects();
        ArrayList<PipelineStatus> details = new ArrayList<PipelineStatus>();
        PipelineResource pipelineRes = new PipelineResource();
        for (HopServerObjectEntry entry : pipelineEntries) {
            details.add(pipelineRes.getPipelineStatus(entry.getId()));
        }
        return details;
    }

    @GET
    @Path(value="/workflows")
    @Produces(value={"application/json"})
    public List<HopServerObjectEntry> getWorkflows() {
        return HopServerSingleton.getInstance().getWorkflowMap().getWorkflowObjects();
    }

    @GET
    @Path(value="/workflows/detailed")
    @Produces(value={"application/json"})
    public List<WorkflowStatus> getWorkflowsDetails() {
        List<HopServerObjectEntry> actions = HopServerSingleton.getInstance().getWorkflowMap().getWorkflowObjects();
        ArrayList<WorkflowStatus> details = new ArrayList<WorkflowStatus>();
        WorkflowResource jobRes = new WorkflowResource();
        for (HopServerObjectEntry entry : actions) {
            details.add(jobRes.getWorkflowStatus(entry.getId()));
        }
        return details;
    }
}

