/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

public abstract class TransformWithMappingMeta<Main extends ITransform, Data extends ITransformData>
extends BaseTransformMeta<Main, Data> {
    private static final Class<?> PKG = TransformWithMappingMeta.class;
    @HopMetadataProperty(hopMetadataPropertyType=HopMetadataPropertyType.PIPELINE_FILE)
    protected String filename;

    public TransformWithMappingMeta() {
    }

    public TransformWithMappingMeta(TransformWithMappingMeta m) {
        this();
        this.filename = m.filename;
    }

    private static IVariables getVarSpaceOnlyWithRequiredParentVars(IVariables parentSpace) {
        Variables tmpSpace = new Variables();
        if (parentSpace != null) {
            tmpSpace.setVariable("Internal.Entry.Current.Folder", parentSpace.getVariable("Internal.Entry.Current.Folder"));
            tmpSpace.setVariable("Internal.Workflow.Filename.Folder", parentSpace.getVariable("Internal.Workflow.Filename.Folder"));
            tmpSpace.setVariable("Internal.Pipeline.Filename.Directory", parentSpace.getVariable("Internal.Pipeline.Filename.Directory"));
            tmpSpace.setVariable("Internal.Workflow.Filename.Name", parentSpace.getVariable("Internal.Workflow.Filename.Name"));
        }
        return tmpSpace;
    }

    public static synchronized PipelineMeta loadMappingMeta(TransformWithMappingMeta executorMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        AbstractMeta mappingPipelineMeta = null;
        CurrentDirectoryResolver r = new CurrentDirectoryResolver();
        IVariables tmpSpace = r.resolveCurrentDirectory(TransformWithMappingMeta.getVarSpaceOnlyWithRequiredParentVars(variables), executorMeta.getParentTransformMeta(), executorMeta.getFilename());
        String realFilename = tmpSpace.resolve(executorMeta.getFilename());
        if (variables != null) {
            realFilename = variables.resolve(realFilename);
        }
        try {
            if (mappingPipelineMeta == null) {
                mappingPipelineMeta = new PipelineMeta(realFilename, metadataProvider, tmpSpace);
                LogChannel.GENERAL.logDetailed("Loading pipeline", new Object[]{"Pipeline was loaded from XML file [" + realFilename + "]"});
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TransformWithMappingMeta.Exception.UnableToLoadPipeline", (String[])new String[0]), (Throwable)e);
        }
        if (mappingPipelineMeta == null) {
            return null;
        }
        mappingPipelineMeta.setMetadataProvider(metadataProvider);
        mappingPipelineMeta.setFilename(mappingPipelineMeta.getFilename());
        return mappingPipelineMeta;
    }

    public static void activateParams(IVariables childVariableSpace, INamedParameters childNamedParams, IVariables parent, String[] listParameters, String[] mappingVariables, String[] inputFields) {
        TransformWithMappingMeta.activateParams(childVariableSpace, childNamedParams, parent, listParameters, mappingVariables, inputFields, true);
    }

    public static void activateParams(IVariables childVariableSpace, INamedParameters childNamedParams, IVariables parent, String[] listParameters, String[] mappingVariables, String[] inputFields, boolean isPassingAllParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashSet<String> subPipelineParameters = new HashSet<String>(Arrays.asList(listParameters));
        if (mappingVariables != null) {
            for (int i = 0; i < mappingVariables.length; ++i) {
                String string = mappingVariables[i];
                parameters.put(string, parent.resolve(inputFields[i]));
                if (Utils.isEmpty((CharSequence)Const.trim((String)parent.resolve(inputFields[i])))) continue;
                parent.setVariable(string, parent.resolve(inputFields[i]));
            }
        }
        for (String variableName : parent.getVariableNames()) {
            if (parameters.containsKey(variableName)) {
                parameters.put(variableName, parent.getVariable(variableName));
                continue;
            }
            if (!ArrayUtils.contains((Object[])listParameters, (Object)variableName) || !isPassingAllParameters) continue;
            parameters.put(variableName, parent.getVariable(variableName));
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = Const.NVL((String)((String)entry.getValue()), (String)"");
            if (subPipelineParameters.contains(key)) {
                try {
                    childNamedParams.setParameterValue(key, Const.NVL((String)((String)entry.getValue()), (String)""));
                }
                catch (UnknownParamException unknownParamException) {}
                continue;
            }
            try {
                childNamedParams.addParameterDefinition(key, "", "");
                childNamedParams.setParameterValue(key, value);
            }
            catch (DuplicateParamException | UnknownParamException throwable) {
                // empty catch block
            }
            childVariableSpace.setVariable(key, value);
        }
        childNamedParams.activateParameters(childVariableSpace);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void replaceFileName(String fileName) {
        this.filename = fileName;
    }

    @Override
    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            PipelineMeta mappingPipelineMeta = TransformWithMappingMeta.loadMappingMeta(this, metadataProvider, variables);
            String proposedNewFilename = mappingPipelineMeta.exportResources(variables, definitions, iResourceNaming, metadataProvider);
            String newFilename = "${Internal.Entry.Current.Folder}/" + proposedNewFilename;
            mappingPipelineMeta.setFilename(newFilename);
            this.replaceFileName(newFilename);
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TransformWithMappingMeta.Exception.UnableToLoadPipeline", (String[])new String[]{this.filename}));
        }
    }

    public static void addMissingVariables(IVariables fromSpace, IVariables toSpace) {
        String[] variableNames;
        if (toSpace == null) {
            return;
        }
        for (String variable : variableNames = toSpace.getVariableNames()) {
            if (fromSpace.getVariable(variable) != null) continue;
            fromSpace.setVariable(variable, toSpace.getVariable(variable));
        }
    }

    public static void replaceVariableValues(IVariables childPipelineMeta, IVariables replaceBy, String type) {
        String[] variableNames;
        if (replaceBy == null) {
            return;
        }
        for (String variableName : variableNames = replaceBy.getVariableNames()) {
            if (childPipelineMeta.getVariable(variableName) == null || TransformWithMappingMeta.isInternalVariable(variableName, type)) continue;
            childPipelineMeta.setVariable(variableName, replaceBy.getVariable(variableName));
        }
    }

    public static void replaceVariableValues(IVariables childPipelineMeta, IVariables replaceBy) {
        TransformWithMappingMeta.replaceVariableValues(childPipelineMeta, replaceBy, "");
    }

    private static boolean isInternalVariable(String variableName, String type) {
        return switch (type) {
            case "Pipeline" -> TransformWithMappingMeta.isPipelineInternalVariable(variableName);
            case "Workflow" -> TransformWithMappingMeta.isWorkflowInternalVariable(variableName);
            default -> TransformWithMappingMeta.isWorkflowInternalVariable(variableName) || TransformWithMappingMeta.isPipelineInternalVariable(variableName);
        };
    }

    private static boolean isPipelineInternalVariable(String variableName) {
        return Const.INTERNAL_PIPELINE_VARIABLES.contains(variableName);
    }

    private static boolean isWorkflowInternalVariable(String variableName) {
        return Const.INTERNAL_WORKFLOW_VARIABLES.contains(variableName);
    }
}

